/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.utils.excel;

import cn.allbs.utils.excel.ExcelConfigProperties;
import cn.allbs.utils.excel.ExcelHandlerConfiguration;
import cn.allbs.utils.excel.aop.DynamicNameAspect;
import cn.allbs.utils.excel.aop.ExportExcelReturnValueHandler;
import cn.allbs.utils.excel.processor.NameProcessor;
import cn.allbs.utils.excel.processor.NameSpelExpressionProcessor;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter;

@Import(value={ExcelHandlerConfiguration.class})
@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={ExcelConfigProperties.class})
public class ExportExcelAutoConfiguration {
    private final RequestMappingHandlerAdapter requestMappingHandlerAdapter;
    private final ExportExcelReturnValueHandler exportExcelReturnValueHandler;

    @Bean
    @ConditionalOnMissingBean
    public NameProcessor nameProcessor() {
        return new NameSpelExpressionProcessor();
    }

    @Bean
    @ConditionalOnMissingBean
    public DynamicNameAspect dynamicNameAspect(NameProcessor nameProcessor) {
        return new DynamicNameAspect(nameProcessor);
    }

    @PostConstruct
    public void setReturnValueHandlers() {
        List returnValueHandlers = this.requestMappingHandlerAdapter.getReturnValueHandlers();
        ArrayList<ExportExcelReturnValueHandler> newHandlers = new ArrayList<ExportExcelReturnValueHandler>();
        newHandlers.add(this.exportExcelReturnValueHandler);
        assert (returnValueHandlers != null);
        newHandlers.addAll(returnValueHandlers);
        this.requestMappingHandlerAdapter.setReturnValueHandlers(newHandlers);
    }

    public ExportExcelAutoConfiguration(RequestMappingHandlerAdapter requestMappingHandlerAdapter, ExportExcelReturnValueHandler exportExcelReturnValueHandler) {
        this.requestMappingHandlerAdapter = requestMappingHandlerAdapter;
        this.exportExcelReturnValueHandler = exportExcelReturnValueHandler;
    }
}

