/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.utils.excel;

import cn.allbs.utils.excel.ExcelConfigProperties;
import cn.allbs.utils.excel.aop.ExportExcelReturnValueHandler;
import cn.allbs.utils.excel.handle.ManySheetWriteHandler;
import cn.allbs.utils.excel.handle.SheetWriteHandler;
import cn.allbs.utils.excel.handle.SingleSheetWriteHandler;
import com.alibaba.excel.converters.Converter;
import java.util.List;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
public class ExcelHandlerConfiguration {
    private final ExcelConfigProperties configProperties;
    private final ObjectProvider<List<Converter<?>>> converterProvider;

    @Bean
    @ConditionalOnMissingBean
    public SingleSheetWriteHandler singleSheetWriteHandler() {
        return new SingleSheetWriteHandler(this.configProperties, this.converterProvider);
    }

    @Bean
    @ConditionalOnMissingBean
    public ManySheetWriteHandler manySheetWriteHandler() {
        return new ManySheetWriteHandler(this.configProperties, this.converterProvider);
    }

    @Bean
    @ConditionalOnMissingBean
    public ExportExcelReturnValueHandler exportExcelReturnValueHandler(List<SheetWriteHandler> sheetWriteHandlerList) {
        return new ExportExcelReturnValueHandler(sheetWriteHandlerList);
    }

    public ExcelHandlerConfiguration(ExcelConfigProperties configProperties, ObjectProvider<List<Converter<?>>> converterProvider) {
        this.configProperties = configProperties;
        this.converterProvider = converterProvider;
    }
}

