/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.utils.common.util;

import cn.allbs.utils.common.enums.ErrorCodeEnum;
import cn.allbs.utils.common.enums.ResponseEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;

@ApiModel(value="\u54cd\u5e94\u4fe1\u606f\u4e3b\u4f53")
public class R<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    @ApiModelProperty(value="\u8fd4\u56de\u6807\u8bc6\uff1a\u6210\u529f-200\uff0c\u5931\u8d25-201, \u5f02\u5e38-\u81ea\u5b9a\u4e49")
    private int code;
    @ApiModelProperty(value="\u8fd4\u56de\u4fe1\u606f")
    private String msg;
    @ApiModelProperty(value="\u6570\u636e")
    private T data;

    public static <T> R<T> ok() {
        return R.restResult(null, ResponseEnum.SUCCESS_RESPONSE.getCode(), null);
    }

    public static <T> R<T> ok(T data) {
        return R.restResult(data, ResponseEnum.SUCCESS_RESPONSE.getCode(), null);
    }

    public static <T> R<T> ok(T data, String msg) {
        return R.restResult(data, ResponseEnum.SUCCESS_RESPONSE.getCode(), msg);
    }

    public static <T> R<T> failed() {
        return R.restResult(null, ResponseEnum.FAILED_RESPONSE.getCode(), null);
    }

    public static <T> R<T> failed(String msg) {
        return R.restResult(null, ResponseEnum.FAILED_RESPONSE.getCode(), msg);
    }

    public static <T> R<T> failed(T data) {
        return R.restResult(data, ResponseEnum.FAILED_RESPONSE.getCode(), null);
    }

    public static <T> R<T> failed(T data, String msg) {
        return R.restResult(data, ResponseEnum.FAILED_RESPONSE.getCode(), msg);
    }

    public static <T> R<T> exception(ErrorCodeEnum errorCodeEnum) {
        return R.restResult(null, errorCodeEnum.getCode(), errorCodeEnum.getErrorMsg());
    }

    public static <T> R<T> exception(int code, String msg) {
        return R.restResult(null, code, msg);
    }

    private static <T> R<T> restResult(T data, int code, String msg) {
        R<T> apiResult = new R<T>();
        apiResult.setCode(code);
        apiResult.setData(data);
        apiResult.setMsg(msg);
        return apiResult;
    }

    public static <T> RBuilder<T> builder() {
        return new RBuilder();
    }

    public String toString() {
        return "R(code=" + this.getCode() + ", msg=" + this.getMsg() + ", data=" + this.getData() + ")";
    }

    public R() {
    }

    public R(int code, String msg, T data) {
        this.code = code;
        this.msg = msg;
        this.data = data;
    }

    public int getCode() {
        return this.code;
    }

    public R<T> setCode(int code) {
        this.code = code;
        return this;
    }

    public String getMsg() {
        return this.msg;
    }

    public R<T> setMsg(String msg) {
        this.msg = msg;
        return this;
    }

    public T getData() {
        return this.data;
    }

    public R<T> setData(T data) {
        this.data = data;
        return this;
    }

    public static class RBuilder<T> {
        private int code;
        private String msg;
        private T data;

        RBuilder() {
        }

        public RBuilder<T> code(int code) {
            this.code = code;
            return this;
        }

        public RBuilder<T> msg(String msg) {
            this.msg = msg;
            return this;
        }

        public RBuilder<T> data(T data) {
            this.data = data;
            return this;
        }

        public R<T> build() {
            return new R<T>(this.code, this.msg, this.data);
        }

        public String toString() {
            return "R.RBuilder(code=" + this.code + ", msg=" + this.msg + ", data=" + this.data + ")";
        }
    }
}

