/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.utils.cache.listener;

import cn.allbs.utils.cache.listener.CacheMessage;
import cn.allbs.utils.cache.support.RedisCaffeineCacheManager;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.connection.Message;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.core.RedisTemplate;

public class CacheMessageListener
implements MessageListener {
    private static final Logger log = LoggerFactory.getLogger(CacheMessageListener.class);
    private final RedisTemplate<Object, Object> redisTemplate;
    private final RedisCaffeineCacheManager redisCaffeineCacheManager;

    public void onMessage(Message message, byte[] pattern) {
        CacheMessage cacheMessage = (CacheMessage)BeanUtil.mapToBean((Map)((Map)this.redisTemplate.getValueSerializer().deserialize(message.getBody())), CacheMessage.class, (boolean)false, (CopyOptions)new CopyOptions());
        log.debug("receive a redis topic message, clear local cache, the cacheName is {}, the key is {}", (Object)cacheMessage.getCacheName(), cacheMessage.getKey());
        this.redisCaffeineCacheManager.clearLocal(cacheMessage.getCacheName(), cacheMessage.getKey());
    }

    public CacheMessageListener(RedisTemplate<Object, Object> redisTemplate, RedisCaffeineCacheManager redisCaffeineCacheManager) {
        this.redisTemplate = redisTemplate;
        this.redisCaffeineCacheManager = redisCaffeineCacheManager;
    }
}

