package cn.allbs.utils.unipush;

import cn.allbs.utils.common.constants.ParamsConstants;
import lombok.AllArgsConstructor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;

/**
 * 功能: 从配置文件中获取个推配置
 *
 * @author chenQi
 * @version 1.0
 * @date 2020/9/29 17:29
 */
@AllArgsConstructor
@EnableConfigurationProperties({UniProperties.class})
@Component
public class UniAutoConfiguration {

    private final UniProperties uniProperties;

    @Bean
    @ConditionalOnMissingBean(UniPushTemplate.class)
    @ConditionalOnProperty(name = "uni-push.url")
    UniPushTemplate uniPushTemplate() {
        return new UniPushTemplate(
                uniProperties.getUrl(),
                uniProperties.getAppId(),
                uniProperties.getAppKey(),
                uniProperties.getMasterSecret(),
                uniProperties.getOfflineExpireTime() == null ? ParamsConstants.OFFLINE_EXPIRE_TIME : uniProperties.getOfflineExpireTime()
        );
    }
}
