package cn.allbs.utils.log;

import cn.allbs.utils.log.model.SysLogUtilsEntity;
import cn.allbs.utils.log.service.SysLogUtilsService;
import lombok.AllArgsConstructor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

/**
 * 功能:
 *
 * @author ChenQi
 * @version 1.0
 * @date 2021/3/10 15:10
 */
@AllArgsConstructor
@Component
public class SysLogListener {

    private final SysLogUtilsService sysLogUtilsService;

    @Async
    @Order
    @EventListener(SysLogEvent.class)
    @ConditionalOnBean(SysLogUtilsService.class)
    public void saveSysLog(SysLogEvent event) {
        SysLogUtilsEntity sysLog = event.getSysLog();
        sysLogUtilsService.saveLog(sysLog);
    }
}
