package cn.allbs.utils.log;

import cn.allbs.utils.log.service.SysLogUtilsService;
import lombok.AllArgsConstructor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableAsync;

/**
 * 功能:
 *
 * @author ChenQi
 * @version 1.0
 * @date 2021/3/29 14:30
 */
@EnableAsync
@Configuration
@AllArgsConstructor
@ConditionalOnWebApplication
@ConditionalOnProperty(name = "allbs.log-active", havingValue = "true")
public class LogConfiguration {

    private final SysLogUtilsService sysLogUtilsService;

    @Bean
    public SysLogListener sysLogListener() {
        return new SysLogListener(sysLogUtilsService);
    }

    @Bean
    public SysLogAspect sysLogAspect(ApplicationEventPublisher publisher) {
        return new SysLogAspect(publisher);
    }
}
