package cn.allbs.utils.hj212.ser;

import cn.allbs.utils.hj212.config.SegmentGenerator;
import cn.allbs.utils.hj212.exception.SegmentFormatException;

import java.io.IOException;
import java.util.Map;

/**
 * 功能:
 *
 * @author chenQi
 * @version 1.0
 * @date 2020/8/23 11:28
 */
public class MapSegmentSerializer
        implements SegmentSerializer<Map<String,Object>> {


    protected SegmentSerializer<Object> valueDeserializer;

    public MapSegmentSerializer() {
        this.valueDeserializer = new MapValueSegmentSerializer(this, o -> {
            throw new SegmentFormatException("Default value serializer not support serialize this type: "
                    + o.getClass().getName());
        });
    }

    public MapSegmentSerializer(SegmentSerializer<Object> _valueDeserializer) {
        this.valueDeserializer = _valueDeserializer;
    }


    @Override
    public void serialize(SegmentGenerator generator, Map<String, Object> data) throws IOException, SegmentFormatException {
        if(generator.nextToken() == null){
            generator.initToken();
        }

        writeMap(generator,data);
    }


    private void writeMap(SegmentGenerator generator, Map<String, Object> result) throws IOException, SegmentFormatException {
        for (Map.Entry<String, Object> kv : result.entrySet()) {
            generator.writeKey(kv.getKey());
            valueDeserializer.serialize(generator,kv.getValue());
        }
    }

    public void setValueDeserializer(SegmentSerializer<Object> valueDeserializer) {
        this.valueDeserializer = valueDeserializer;
    }
}
