package cn.allbs.utils.cache.listener;

import cn.allbs.utils.cache.support.RedisCaffeineCacheManager;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.redis.connection.Message;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.core.RedisTemplate;

import java.util.Map;

/**
 * 功能: MessageListener 删除指定 Caffeine 的指定值
 *
 * @author ChenQi
 * @version 1.0
 * @date 2021/3/20 下午4:16
 */
@Slf4j
@RequiredArgsConstructor
public class CacheMessageListener implements MessageListener {

    private final RedisTemplate<Object, Object> redisTemplate;

    private final RedisCaffeineCacheManager redisCaffeineCacheManager;

    @Override
    public void onMessage(Message message, byte[] pattern) {
        CacheMessage cacheMessage = BeanUtil.mapToBean((Map) redisTemplate.getValueSerializer().deserialize(message.getBody()), CacheMessage.class, false, new CopyOptions());
        log.debug("receive a redis topic message, clear local cache, the cacheName is {}, the key is {}",
                cacheMessage.getCacheName(), cacheMessage.getKey());
        redisCaffeineCacheManager.clearLocal(cacheMessage.getCacheName(), cacheMessage.getKey());
    }

}
