package cn.allbs.utils.sms.huawei;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

/**
 * 功能:
 *
 * @author ChenQi
 * @version 1.0
 * @date 2021/3/10 13:33
 */
@Data
@Component
@ConfigurationProperties(prefix = "sms")
public class HuaweiSmsProperties {

    /**
     * APP接入地址+接口访问URI
     */
    private String url;

    /**
     * APP_Key
     */
    private String appKey;

    /**
     * APP_Secret
     */
    private String appSecret;

    /**
     * 国内短信签名通道号或国际/港澳台短信通道号
     */
    private String sender;

    /**
     * 签名名称
     */
    private String signature;
}
