package cn.allbs.utils.minio;

import cn.allbs.utils.minio.endpoint.MinioEndpoint;
import cn.allbs.utils.minio.template.MinioTemplate;
import cn.hutool.core.bean.BeanUtil;
import lombok.AllArgsConstructor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * @Author: chenqi
 * @Describe:
 * @Date: 2020/8/19 11:18
 * @Version 1.0
 */
@AllArgsConstructor
@EnableConfigurationProperties({MinioProperties.class})
@Configuration
public class MinioAutoConfiguration {

    private final MinioProperties properties;

    @Bean
    @ConditionalOnMissingBean(MinioTemplate.class)
    @ConditionalOnProperty(name = "minio.url")
    public MinioTemplate template() {
        MinioTemplate minioTemplate = new MinioTemplate(properties);
        return minioTemplate;
    }


    @Bean
    @ConditionalOnProperty(name = "minio.endpoint.enable", havingValue = "true")
    public MinioEndpoint minioEndpoint(MinioTemplate template) {
        return new MinioEndpoint(template);
    }

}