package cn.allbs.utils.hj212.ser;

import cn.allbs.utils.hj212.config.SegmentGenerator;
import cn.allbs.utils.hj212.exception.SegmentFormatException;

import java.io.IOException;
import java.util.Map;

/**
 * 功能:
 *
 * @author chenQi
 * @version 1.0
 * @date 2020/8/23 11:29
 */
public class StringMapSegmentSerializer
        implements SegmentSerializer<Map<String, String>> {

    @Override
    public void serialize(SegmentGenerator generator, Map<String, String> data) throws IOException, SegmentFormatException {
        if (generator.nextToken() == null) {
            generator.initToken();
        }
        writeMap(generator, data);
    }

    private void writeMap(SegmentGenerator generator, Map<String, String> result) throws IOException, SegmentFormatException {
        for (Map.Entry<String, String> kv : result.entrySet()) {
            generator.writeKey(kv.getKey());
            generator.writeValue(kv.getValue());
        }
    }

}
