package cn.allbs.utils.hj212.enums;

import cn.allbs.utils.hj212.translator.CodeMean;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.function.Predicate;
import java.util.regex.Pattern;

/**
 * 功能:
 *
 * @author chenQi
 * @version 1.0
 * @date 2020/8/23 9:39
 */
@Getter
@AllArgsConstructor
public enum CommandType implements CodeMean {

    /**
     * 请求命令
     */
    REQUEST("请求命令", "[1]\\d{3}"),
    UPLOAD("上传命令", "[2]\\d{3}"),
    NOTICE("通知命令", "[3]\\d{3}"),
    SHELL("交互命令", "[9]\\d{3}"),
    UNKNOW("未知", "\\d{4}", 10000);

    private String code;
    private String meaning;
    private String pattern;
    private Predicate<String> predicate;
    private int order;

    CommandType(String meaning, String pattern) {
        this.code = name();
        this.meaning = meaning;
        this.pattern = pattern;
        this.predicate = Pattern.compile(this.pattern).asPredicate();
        this.order = ordinal();
    }

    CommandType(String meaning, String pattern, int order) {
        this.code = name();
        this.meaning = meaning;
        this.pattern = pattern;
        this.predicate = Pattern.compile(this.pattern).asPredicate();
        this.order = order;
    }

    @Override
    public String code() {
        return code;
    }

    @Override
    public String mean() {
        return meaning;
    }
}
