/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.unipush;

import cn.allbs.unipush.enums.MobileType;
import com.gexin.fastjson.JSON;
import com.gexin.rp.sdk.base.IPushResult;
import com.gexin.rp.sdk.base.ITemplate;
import com.gexin.rp.sdk.base.impl.AppMessage;
import com.gexin.rp.sdk.base.impl.SingleMessage;
import com.gexin.rp.sdk.base.impl.Target;
import com.gexin.rp.sdk.base.payload.APNPayload;
import com.gexin.rp.sdk.base.payload.Payload;
import com.gexin.rp.sdk.http.IGtPush;
import com.gexin.rp.sdk.template.AbstractTemplate;
import com.gexin.rp.sdk.template.LinkTemplate;
import com.gexin.rp.sdk.template.NotificationTemplate;
import com.gexin.rp.sdk.template.TransmissionTemplate;
import com.gexin.rp.sdk.template.style.AbstractNotifyStyle;
import com.gexin.rp.sdk.template.style.Style0;
import java.util.ArrayList;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class UniPushTemplate
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(UniPushTemplate.class);
    private final String url;
    private final String appId;
    private final String appKey;
    private final String masterSecret;
    private final Long offlineExpireTime;
    private IGtPush push;

    public void pushToAllUser(String title, String content) {
        Style0 style = new Style0();
        style.setTitle(title);
        style.setText(content);
        style.setLogo("push.png");
        style.setRing(true);
        style.setVibrate(true);
        NotificationTemplate template = new NotificationTemplate();
        template.setAppId(this.appId);
        template.setAppkey(this.appKey);
        template.setStyle((AbstractNotifyStyle)style);
        ArrayList<String> appIds = new ArrayList<String>();
        appIds.add(this.appId);
        AppMessage message = new AppMessage();
        message.setData((ITemplate)template);
        message.setAppIdList(appIds);
        message.setOffline(true);
        message.setOfflineExpireTime(this.offlineExpireTime * 60L * 1000L);
        IPushResult ret = this.push.pushMessageToApp(message);
        log.info("app message push to all user, response is " + ret.getResponse().toString());
    }

    public void pushToAssignUser(String title, String content, String clientId, Integer type) {
        Style0 style = new Style0();
        style.setTitle(title);
        style.setText(content);
        style.setLogo("push.png");
        style.setRing(true);
        style.setVibrate(true);
        Object template = null;
        template = MobileType.ANDROID.getType().equals(type) ? this.getNotificationTemplate(title, content) : (MobileType.IOS.getType().equals(type) ? this.getIOSTemplate(title, content) : this.getLinkTemplate());
        this.pushToSingle(clientId, (AbstractTemplate)template);
    }

    private void pushToSingle(String clientId, AbstractTemplate template) {
        SingleMessage message = new SingleMessage();
        message.setData((ITemplate)template);
        message.setOffline(true);
        message.setData((ITemplate)template);
        message.setPushNetWorkType(0);
        message.setOfflineExpireTime(this.offlineExpireTime * 60L * 1000L);
        Target target = new Target();
        target.setAppId(this.appId);
        target.setClientId(clientId);
        IPushResult ret = this.push.pushMessageToSingle(message, target);
        log.info("app message push to signal user, response is " + ret.getResponse().toString());
    }

    private NotificationTemplate getNotificationTemplate(String title, String text) {
        NotificationTemplate template = new NotificationTemplate();
        template.setAppId(this.appId);
        template.setAppkey(this.appKey);
        template.setTitle(title);
        template.setText(text);
        template.setLogoUrl(this.url);
        return template;
    }

    public TransmissionTemplate getIOSTemplate(String title, String content) {
        TransmissionTemplate template = new TransmissionTemplate();
        template.setAppId(this.appId);
        template.setAppkey(this.appKey);
        HashMap<String, String> contentMap = new HashMap<String, String>();
        contentMap.put("content", content);
        contentMap.put("title", title);
        String jsonString = JSON.toJSONString(contentMap);
        template.setTransmissionType(2);
        template.setTransmissionContent(jsonString);
        APNPayload payload = new APNPayload();
        payload.setSound("default");
        payload.setCategory("$\u7531\u5ba2\u6237\u7aef\u5b9a\u4e49");
        payload.setAlertMsg((APNPayload.AlertMsg)UniPushTemplate.getDictionaryAlertMsg(title, content));
        template.setAPNInfo((Payload)payload);
        return template;
    }

    private LinkTemplate getLinkTemplate() {
        LinkTemplate template = new LinkTemplate();
        template.setAppId(this.appId);
        template.setAppkey(this.appKey);
        template.setTitle("\u544a\u8b66\u901a\u77e5");
        template.setText("");
        template.setUrl("http://getui.com");
        template.setLogoUrl(this.url);
        return template;
    }

    private static APNPayload.DictionaryAlertMsg getDictionaryAlertMsg(String title, String content) {
        APNPayload.DictionaryAlertMsg alertMsg = new APNPayload.DictionaryAlertMsg();
        alertMsg.setBody(content);
        alertMsg.setActionLocKey("ActionLockey");
        alertMsg.setLocKey("LocKey");
        alertMsg.addLocArg("loc-args");
        alertMsg.setLaunchImage("launch-image");
        alertMsg.setTitle(title);
        alertMsg.setTitleLocKey("TitleLocKey");
        alertMsg.addTitleLocArg("TitleLocArg");
        return alertMsg;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.hasText((String)this.url, (String)"url \u4e3a\u7a7a");
        Assert.hasText((String)this.appKey, (String)"appKey\u4e3a\u7a7a");
        Assert.hasText((String)this.masterSecret, (String)"masterSecret\u4e3a\u7a7a");
        this.push = new IGtPush(this.url, this.appKey, this.masterSecret);
    }

    public UniPushTemplate(String url, String appId, String appKey, String masterSecret, Long offlineExpireTime) {
        this.url = url;
        this.appId = appId;
        this.appKey = appKey;
        this.masterSecret = masterSecret;
        this.offlineExpireTime = offlineExpireTime;
    }
}

