package cn.allbs.unipush.enums;

/**
 * 枚举 MobileType
 * </p>
 *
 * @author ChenQi
 * @since 2023/3/17 10:02
 */
public enum MobileType {

    /**
     * 手机类型区分
     */
    ANDROID(0, "android"),

    IOS(1, "ios");

    /**
     * 手机类型
     */
    private final Integer type;

    /**
     * 描述
     */
    private final String desc;

    MobileType(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public Integer getType() {
        return this.type;
    }

    public String getDesc() {
        return this.desc;
    }
}
