/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.swagger;

import cn.allbs.swagger.SwaggerProperties;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.ExternalDocumentation;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import java.util.Optional;
import org.springdoc.core.GroupedOpenApi;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.info.BuildProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;

@Configuration
@EnableConfigurationProperties(value={SwaggerProperties.class})
public class Swagger3Config {
    private final SwaggerProperties swaggerProperties;

    @Bean
    @Profile(value={"dev", "test"})
    public OpenAPI openApi(ObjectProvider<BuildProperties> buildProperties) {
        OpenAPI openApi = new OpenAPI();
        if (null != this.swaggerProperties.getSecuritySchemes() && !this.swaggerProperties.getSecuritySchemes().isEmpty()) {
            openApi.components(new Components().securitySchemes(this.swaggerProperties.getSecuritySchemes()));
            this.swaggerProperties.getSecuritySchemes().keySet().forEach(key -> openApi.addSecurityItem(new SecurityRequirement().addList(key)));
        }
        openApi.info(new Info().title(this.swaggerProperties.getTitle()).description(this.swaggerProperties.getDescription()).version(Optional.ofNullable(buildProperties.getIfAvailable()).map(BuildProperties::getVersion).orElse(this.swaggerProperties.getVersion())));
        if (this.swaggerProperties.getServers() != null && !this.swaggerProperties.getServers().isEmpty()) {
            openApi.servers(this.swaggerProperties.getServers());
        }
        openApi.externalDocs(new ExternalDocumentation());
        return openApi;
    }

    @Bean
    public GroupedOpenApi publicApi() {
        return GroupedOpenApi.builder().group(this.swaggerProperties.getTitle()).pathsToMatch(new String[]{"/**"}).build();
    }

    public Swagger3Config(SwaggerProperties swaggerProperties) {
        this.swaggerProperties = swaggerProperties;
    }
}

