/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.swagger;

import cn.allbs.swagger.SwaggerProperties;
import cn.hutool.core.collection.CollUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.ApiKey;
import springfox.documentation.service.AuthorizationScope;
import springfox.documentation.service.SecurityReference;
import springfox.documentation.service.SecurityScheme;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.contexts.SecurityContext;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@Configuration
@EnableConfigurationProperties(value={SwaggerProperties.class})
@EnableSwagger2
public class Swagger2Config {
    private final SwaggerProperties swaggerProperties;

    @Profile(value={"dev", "test"})
    @Bean
    public Docket createRestApi() {
        ApiInfo apiInfo = new ApiInfoBuilder().title(this.swaggerProperties.getTitle()).description(this.swaggerProperties.getDescription()).contact(this.swaggerProperties.getContact()).termsOfServiceUrl(this.swaggerProperties.getTermServiceUrl()).version(this.swaggerProperties.getVersion()).build();
        return new Docket(DocumentationType.SWAGGER_2).host(this.swaggerProperties.getHost()).groupName(this.swaggerProperties.getGroupName()).apiInfo(apiInfo).ignoredParameterTypes(new Class[0]).select().apis(RequestHandlerSelectors.withMethodAnnotation(ApiOperation.class)).apis(RequestHandlerSelectors.withClassAnnotation(Api.class)).apis(RequestHandlerSelectors.basePackage((String)this.swaggerProperties.getBasePackage())).paths(PathSelectors.any()).build().securitySchemes(this.securitySchemes()).securityContexts(this.securityContexts());
    }

    private List<SecurityScheme> securitySchemes() {
        ArrayList<SecurityScheme> securitySchemes = new ArrayList<SecurityScheme>();
        securitySchemes.add((SecurityScheme)new ApiKey(this.swaggerProperties.getAuth(), this.swaggerProperties.getAuth(), "header"));
        return securitySchemes;
    }

    private List<SecurityContext> securityContexts() {
        ArrayList<SecurityContext> securityContexts = new ArrayList<SecurityContext>();
        if (CollUtil.isEmpty(this.swaggerProperties.getIgnorePrefix())) {
            securityContexts.add(SecurityContext.builder().securityReferences(this.defaultAuth()).operationSelector(operationContext -> true).build());
        } else {
            this.swaggerProperties.getIgnorePrefix().forEach(a -> securityContexts.add(SecurityContext.builder().securityReferences(this.defaultAuth()).operationSelector(operationContext -> !operationContext.requestMappingPattern().startsWith((String)a)).build()));
        }
        return securityContexts;
    }

    List<SecurityReference> defaultAuth() {
        AuthorizationScope authorizationScope = new AuthorizationScope("global", "accessEverything");
        AuthorizationScope[] authorizationScopes = new AuthorizationScope[]{authorizationScope};
        ArrayList<SecurityReference> securityReferences = new ArrayList<SecurityReference>();
        securityReferences.add(new SecurityReference(this.swaggerProperties.getAuth(), authorizationScopes));
        return securityReferences;
    }

    public Swagger2Config(SwaggerProperties swaggerProperties) {
        this.swaggerProperties = swaggerProperties;
    }
}

