package cn.allbs.swagger;

import cn.hutool.core.collection.CollUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.*;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.contexts.SecurityContext;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

import java.util.ArrayList;
import java.util.List;

/**
 * 功能:
 *
 * @author ChenQi
 * @version 1.0
 * @since 2021/3/5 8:58
 */
@Configuration
@EnableConfigurationProperties({SwaggerProperties.class})
@EnableSwagger2
@AllArgsConstructor
public class Swagger2Config {

    private final SwaggerProperties swaggerProperties;

    @Profile({"dev", "test"})
    @Bean
    public Docket createRestApi() {
        ApiInfo apiInfo = new ApiInfoBuilder().title(swaggerProperties.getTitle()).description(swaggerProperties.getDescription()).contact(swaggerProperties.getContact()).termsOfServiceUrl(swaggerProperties.getTermServiceUrl()).version(swaggerProperties.getVersion()).build();

        return new Docket(DocumentationType.SWAGGER_2).host(swaggerProperties.getHost()).groupName(swaggerProperties.getGroupName()).apiInfo(apiInfo).ignoredParameterTypes().select().apis(RequestHandlerSelectors.withMethodAnnotation(ApiOperation.class)).apis(RequestHandlerSelectors.withClassAnnotation(Api.class)).apis(RequestHandlerSelectors.basePackage(swaggerProperties.getBasePackage())).paths(PathSelectors.any()).build().securitySchemes(securitySchemes()).securityContexts(securityContexts());
    }

    private List<SecurityScheme> securitySchemes() {
        List<SecurityScheme> securitySchemes = new ArrayList<>();
        securitySchemes.add(new ApiKey(swaggerProperties.getAuth(), swaggerProperties.getAuth(), "header"));
        return securitySchemes;
    }

    private List<SecurityContext> securityContexts() {
        List<SecurityContext> securityContexts = new ArrayList<>();
        if (CollUtil.isEmpty(swaggerProperties.getIgnorePrefix())) {
            securityContexts.add(SecurityContext.builder().securityReferences(defaultAuth()).operationSelector(operationContext -> true).build());
        } else {
            swaggerProperties.getIgnorePrefix().forEach(a -> securityContexts.add(SecurityContext.builder().securityReferences(defaultAuth()).operationSelector(operationContext -> !operationContext.requestMappingPattern().startsWith(a)).build()));
        }
        return securityContexts;
    }

    List<SecurityReference> defaultAuth() {
        AuthorizationScope authorizationScope = new AuthorizationScope("global", "accessEverything");
        AuthorizationScope[] authorizationScopes = new AuthorizationScope[1];
        authorizationScopes[0] = authorizationScope;
        List<SecurityReference> securityReferences = new ArrayList<>();
        securityReferences.add(new SecurityReference(swaggerProperties.getAuth(), authorizationScopes));
        return securityReferences;
    }
}