/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.sms.util;

import cn.hutool.core.convert.ConverterRegistry;
import cn.hutool.core.lang.Editor;
import cn.hutool.core.text.StrJoiner;
import cn.hutool.core.util.StrUtil;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;

public final class Utils {
    private static final String SUCCESS_CODE = "OK";
    private static final String PHONE_NUMBER_REGEX = "\\d{5,}";

    public static int randomCode() {
        return 100000 + ThreadLocalRandom.current().nextInt(900000);
    }

    public static String toJsonStr(Map<String, String> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        for (Map.Entry<String, String> entry : map.entrySet()) {
            sb.append('\"').append(entry.getKey().replace("\"", "\\\"")).append('\"').append(':').append('\"').append(entry.getValue().replace("\"", "\\\"")).append('\"').append(',');
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append('}');
        return sb.toString();
    }

    public static void checkPhoneNumber(String ... phoneNumbers) {
        if (phoneNumbers.length == 0) {
            throw new IllegalArgumentException("Invalid phone size");
        }
        for (String phoneNumber : phoneNumbers) {
            if (phoneNumber.matches(PHONE_NUMBER_REGEX)) continue;
            throw new IllegalArgumentException("Invalid phone number " + phoneNumber);
        }
    }

    public static void checkNotEmpty(String str, String message) {
        if (null == str || str.isEmpty()) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void checkNotEmpty(Collection coll, String message) {
        if (null == coll || coll.isEmpty()) {
            throw new IllegalArgumentException(message);
        }
    }

    public static <T> String join(T[] array, CharSequence conjunction) {
        return Utils.join(array, conjunction, null, null);
    }

    public static <T> String join(T[] array, CharSequence delimiter, String prefix, String suffix) {
        if (null == array) {
            return null;
        }
        return StrJoiner.of((CharSequence)delimiter, (CharSequence)prefix, (CharSequence)suffix).setWrapElement(true).append((Object[])array).toString();
    }

    public static <T> String join(T[] array, CharSequence conjunction, Editor<T> editor) {
        return StrJoiner.of((CharSequence)conjunction).append((Object[])array, t -> String.valueOf(editor.edit(t))).toString();
    }

    public static String join(Object array, CharSequence conjunction) {
        if (null == array) {
            return null;
        }
        if (!Utils.isArray(array)) {
            throw new IllegalArgumentException(StrUtil.format((CharSequence)"[{}] is not a Array!", (Object[])new Object[]{array.getClass()}));
        }
        return StrJoiner.of((CharSequence)conjunction).append(array).toString();
    }

    public static boolean isArray(Object obj) {
        return null != obj && obj.getClass().isArray();
    }

    public static Integer toInt(Object value, Integer defaultValue) {
        return Utils.convertQuietly(Integer.class, value, defaultValue);
    }

    public static <T> T convertQuietly(Type type, Object value, T defaultValue) {
        return Utils.convertWithCheck(type, value, defaultValue, true);
    }

    public static <T> T convertWithCheck(Type type, Object value, T defaultValue, boolean quietly) {
        ConverterRegistry registry = ConverterRegistry.getInstance();
        try {
            return (T)registry.convert(type, value, defaultValue);
        }
        catch (Exception e) {
            if (quietly) {
                return defaultValue;
            }
            throw e;
        }
    }

    private Utils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

