/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.sms;

import cn.allbs.sms.client.AliYunClient;
import cn.allbs.sms.client.HuaWeiYunClient;
import cn.allbs.sms.client.TencentCloudClient;
import cn.allbs.sms.properties.SmsClientProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={SmsClientProperties.class})
public class SmsAutoConfiguration {
    private final SmsClientProperties smsClientProperties;

    @Bean
    @ConditionalOnMissingBean(value={AliYunClient.class})
    @ConditionalOnProperty(prefix="sms.ali", name={"enable"}, havingValue="true")
    public AliYunClient aliYunClient() {
        return new AliYunClient(this.smsClientProperties);
    }

    @Bean
    @ConditionalOnMissingBean(value={TencentCloudClient.class})
    @ConditionalOnProperty(prefix="sms.tx", name={"enable"}, havingValue="true")
    public TencentCloudClient tencentCloudClient() {
        return new TencentCloudClient(this.smsClientProperties);
    }

    @Bean
    @ConditionalOnMissingBean(value={HuaWeiYunClient.class})
    @ConditionalOnProperty(prefix="sms.huawei", name={"enable"}, havingValue="true")
    public HuaWeiYunClient huaWeiYunClient() {
        return new HuaWeiYunClient(this.smsClientProperties);
    }

    public SmsAutoConfiguration(SmsClientProperties smsClientProperties) {
        this.smsClientProperties = smsClientProperties;
    }
}

