/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.mybatis.utils;

import cn.hutool.core.util.StrUtil;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.expression.operators.relational.ItemsList;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.parameter.ParameterHandler;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.apache.ibatis.session.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PluginUtils {
    private static final Logger log = LoggerFactory.getLogger(PluginUtils.class);
    public static final String DELEGATE_BOUNDSQL_SQL = "delegate.boundSql.sql";

    public static <T> T realTarget(Object target) {
        if (Proxy.isProxyClass(target.getClass())) {
            MetaObject metaObject = SystemMetaObject.forObject((Object)target);
            return PluginUtils.realTarget(metaObject.getValue("h.target"));
        }
        return (T)target;
    }

    public static void setAdditionalParameter(BoundSql boundSql, Map<String, Object> additionalParameters) {
        additionalParameters.forEach((arg_0, arg_1) -> ((BoundSql)boundSql).setAdditionalParameter(arg_0, arg_1));
    }

    public static MPBoundSql mpBoundSql(BoundSql boundSql) {
        return new MPBoundSql(boundSql);
    }

    public static MPStatementHandler mpStatementHandler(StatementHandler statementHandler) {
        statementHandler = (StatementHandler)PluginUtils.realTarget(statementHandler);
        MetaObject object = SystemMetaObject.forObject((Object)statementHandler);
        return new MPStatementHandler(SystemMetaObject.forObject((Object)object.getValue("delegate")));
    }

    public static <T> ItemsList getItemList(Set<T> dataPmsList) {
        LinkedList<Expression> list = new LinkedList<Expression>();
        for (T a : dataPmsList) {
            try {
                Expression expression = CCJSqlParserUtil.parseCondExpression((String)StrUtil.join((CharSequence)",", (Object[])new Object[]{a}));
                list.add(expression);
            }
            catch (JSQLParserException e) {
                log.error("\u7b5b\u9009\u6570\u636e\u8f6c\u6362\u4e3a\u8868\u8fbe\u5f0f\u5931\u8d25!" + e.getLocalizedMessage());
            }
        }
        return new ExpressionList(list);
    }

    public static class MPBoundSql {
        private final MetaObject boundSql;
        private final BoundSql delegate;

        MPBoundSql(BoundSql boundSql) {
            this.delegate = boundSql;
            this.boundSql = SystemMetaObject.forObject((Object)boundSql);
        }

        public String sql() {
            return this.delegate.getSql();
        }

        public void sql(String sql) {
            this.boundSql.setValue("sql", (Object)sql);
        }

        public List<ParameterMapping> parameterMappings() {
            List parameterMappings = this.delegate.getParameterMappings();
            return new ArrayList<ParameterMapping>(parameterMappings);
        }

        public void parameterMappings(List<ParameterMapping> parameterMappings) {
            this.boundSql.setValue("parameterMappings", Collections.unmodifiableList(parameterMappings));
        }

        public Object parameterObject() {
            return this.get("parameterObject");
        }

        public Map<String, Object> additionalParameters() {
            return (Map)this.get("additionalParameters");
        }

        private <T> T get(String property) {
            return (T)this.boundSql.getValue(property);
        }
    }

    public static class MPStatementHandler {
        private final MetaObject statementHandler;

        MPStatementHandler(MetaObject statementHandler) {
            this.statementHandler = statementHandler;
        }

        public ParameterHandler parameterHandler() {
            return (ParameterHandler)this.get("parameterHandler");
        }

        public MappedStatement mappedStatement() {
            return (MappedStatement)this.get("mappedStatement");
        }

        public Executor executor() {
            return (Executor)this.get("executor");
        }

        public MPBoundSql mPBoundSql() {
            return new MPBoundSql(this.boundSql());
        }

        public BoundSql boundSql() {
            return (BoundSql)this.get("boundSql");
        }

        public Configuration configuration() {
            return (Configuration)this.get("configuration");
        }

        private <T> T get(String property) {
            return (T)this.statementHandler.getValue(property);
        }
    }
}

