/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.mybatis.filter;

import cn.allbs.mybatis.properties.MybatisProperties;
import cn.allbs.mybatis.utils.TableConsoleUtil;
import com.alibaba.druid.DbType;
import com.alibaba.druid.filter.FilterChain;
import com.alibaba.druid.filter.FilterEventAdapter;
import com.alibaba.druid.proxy.jdbc.JdbcParameter;
import com.alibaba.druid.proxy.jdbc.ResultSetProxy;
import com.alibaba.druid.proxy.jdbc.StatementProxy;
import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.util.StringUtils;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DruidSqlLogFilter
extends FilterEventAdapter {
    private static final Logger log = LoggerFactory.getLogger(DruidSqlLogFilter.class);
    private static final SQLUtils.FormatOption FORMAT_OPTION = new SQLUtils.FormatOption(false, false);
    private final MybatisProperties mybatisProperties;
    private boolean first = true;
    private static final Set<Integer> BLOB_TYPES = new HashSet<Integer>();
    private ResultSet rs;
    private final Set<Integer> blobColumns = new HashSet<Integer>();
    private int rows;
    private List<String> rowList = new LinkedList<String>();
    private boolean STATEMENT_CLOSE_RUN = true;

    public DruidSqlLogFilter(MybatisProperties mybatisProperties) {
        this.mybatisProperties = mybatisProperties;
    }

    protected void statementExecuteBefore(StatementProxy statement, String sql) {
        statement.setLastExecuteStartNano();
    }

    protected void statementExecuteBatchBefore(StatementProxy statement) {
        statement.setLastExecuteStartNano();
    }

    protected void statementExecuteUpdateBefore(StatementProxy statement, String sql) {
        statement.setLastExecuteStartNano();
    }

    protected void statementExecuteQueryBefore(StatementProxy statement, String sql) {
        statement.setLastExecuteStartNano();
    }

    protected void statementExecuteAfter(StatementProxy statement, String sql, boolean firstResult) {
        statement.setLastExecuteTimeNano();
    }

    protected void statementExecuteBatchAfter(StatementProxy statement, int[] result) {
        statement.setLastExecuteTimeNano();
    }

    protected void statementExecuteQueryAfter(StatementProxy statement, String sql, ResultSetProxy resultSet) {
        statement.setLastExecuteTimeNano();
    }

    protected void statementExecuteUpdateAfter(StatementProxy statement, String sql, int updateCount) {
        statement.setLastExecuteTimeNano();
    }

    public void statement_close(FilterChain chain, StatementProxy statement) throws SQLException {
        super.statement_close(chain, statement);
        if (!this.mybatisProperties.isShowSql()) {
            return;
        }
        if (!log.isInfoEnabled()) {
            return;
        }
        if (!this.STATEMENT_CLOSE_RUN) {
            this.STATEMENT_CLOSE_RUN = true;
            return;
        }
        String sql = statement.getBatchSql();
        if (StringUtils.isEmpty((CharSequence)sql)) {
            return;
        }
        String executeSql = this.statement(statement);
        log.info(executeSql);
    }

    public String statement(StatementProxy statement) {
        String sql = statement.getBatchSql();
        if (StringUtils.isEmpty((CharSequence)sql)) {
            return "";
        }
        int parametersSize = statement.getParametersSize();
        ArrayList<Object> parameters = new ArrayList<Object>(parametersSize);
        for (int i = 0; i < parametersSize; ++i) {
            parameters.add(DruidSqlLogFilter.getJdbcParameter(statement.getParameter(i)));
        }
        String dbType = statement.getConnectionProxy().getDirectDataSource().getDbType();
        String formattedSql = SQLUtils.format((String)sql, (DbType)DbType.of((String)dbType), parameters, (SQLUtils.FormatOption)FORMAT_OPTION);
        return DruidSqlLogFilter.printSql(formattedSql, statement);
    }

    private static Object getJdbcParameter(JdbcParameter jdbcParam) {
        if (jdbcParam == null) {
            return null;
        }
        Object value = jdbcParam.getValue();
        if (value instanceof TemporalAccessor) {
            return value.toString();
        }
        return value;
    }

    private static String printSql(String sql, StatementProxy statement) {
        String sqlLogger = "\n--------------------------------[ %s Sql Log ]---------------------------------\n%s\n--------------------------------[ Sql Execute Time: %s  ]---------------------------------\n";
        return String.format(sqlLogger, LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")), sql.trim(), DruidSqlLogFilter.format(statement.getLastExecuteTimeNano()));
    }

    private static String format(long nanos) {
        if (nanos < 1L) {
            return "0ms";
        }
        double millis = (double)nanos / 1000000.0;
        if (millis > 1000.0) {
            return String.format("%.3fs", millis / 1000.0);
        }
        return String.format("%.3fms", millis);
    }

    public boolean resultSet_next(FilterChain chain, ResultSetProxy resultSet) throws SQLException {
        boolean next = super.resultSet_next(chain, resultSet);
        if (!this.mybatisProperties.isShowSql()) {
            return next;
        }
        if (!log.isInfoEnabled()) {
            return next;
        }
        if (!next) {
            String querySql = this.statement(resultSet.getStatementProxy());
            String sqlLogger = querySql + "{}--------------------------------[ Results Total {} ]---------------------------------\n";
            String results = "";
            if (this.rowList.size() > 0) {
                results = TableConsoleUtil.printResult(this.rowList, this.mybatisProperties.getChineRate());
            }
            log.info(sqlLogger, (Object)results, (Object)this.rows);
            this.rows = 0;
            this.rowList = new LinkedList<String>();
            this.first = true;
            this.STATEMENT_CLOSE_RUN = false;
            return false;
        }
        this.STATEMENT_CLOSE_RUN = true;
        ++this.rows;
        this.rs = resultSet.getResultSetRaw();
        ResultSetMetaData rsmd = resultSet.getMetaData();
        int columnCount = rsmd.getColumnCount();
        if (this.first) {
            this.first = false;
            this.printColumnHeaders(rsmd, columnCount);
        }
        this.printColumnValues(columnCount);
        return true;
    }

    private void printColumnHeaders(ResultSetMetaData rsmd, int columnCount) throws SQLException {
        StringJoiner row = new StringJoiner(",");
        for (int i = 1; i <= columnCount; ++i) {
            if (BLOB_TYPES.contains(rsmd.getColumnType(i))) {
                this.blobColumns.add(i);
            }
            row.add(rsmd.getColumnLabel(i));
        }
        this.rowList.add(row.toString());
    }

    private void printColumnValues(int columnCount) {
        StringJoiner row = new StringJoiner(",");
        for (int i = 1; i <= columnCount; ++i) {
            try {
                if (this.blobColumns.contains(i)) {
                    row.add("<<BLOB>>");
                    continue;
                }
                row.add(this.rs.getString(i));
                continue;
            }
            catch (SQLException e) {
                row.add("<<Cannot Display>>");
            }
        }
        this.rowList.add(row.toString());
    }

    static {
        BLOB_TYPES.add(-2);
        BLOB_TYPES.add(2004);
        BLOB_TYPES.add(2005);
        BLOB_TYPES.add(-16);
        BLOB_TYPES.add(-4);
        BLOB_TYPES.add(-1);
        BLOB_TYPES.add(2011);
        BLOB_TYPES.add(-3);
    }
}

