/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.mybatis.datascope;

import cn.allbs.mybatis.datascope.DataPmsHandler;
import cn.allbs.mybatis.execption.UserOverreachException;
import cn.allbs.mybatis.utils.PluginUtils;
import com.baomidou.mybatisplus.core.plugins.InterceptorIgnoreHelper;
import com.baomidou.mybatisplus.extension.parser.JsqlParserSupport;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.delete.Delete;
import net.sf.jsqlparser.statement.insert.Insert;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.statement.select.SetOperationList;
import net.sf.jsqlparser.statement.update.Update;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataPmsInterceptor
extends JsqlParserSupport
implements InnerInterceptor {
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private DataPmsHandler dataPermissionHandler;

    public void beforeQuery(Executor executor, MappedStatement ms, Object parameter, RowBounds rowBounds, ResultHandler resultHandler, BoundSql boundSql) throws SQLException {
        if (InterceptorIgnoreHelper.willIgnoreTenantLine((String)ms.getId())) {
            return;
        }
        if (ms.getId().contains("_mpCount") && InterceptorIgnoreHelper.willIgnoreDataPermission((String)ms.getId().replace("_mpCount", ""))) {
            return;
        }
        PluginUtils.MPBoundSql mpBs = PluginUtils.mpBoundSql(boundSql);
        mpBs.sql(this.parserSingle(mpBs.sql(), null));
    }

    public void beforePrepare(StatementHandler sh, Connection connection, Integer transactionTimeout) {
        PluginUtils.MPStatementHandler mpSh = PluginUtils.mpStatementHandler(sh);
        MappedStatement ms = mpSh.mappedStatement();
        SqlCommandType sct = ms.getSqlCommandType();
        if (sct == SqlCommandType.UPDATE || sct == SqlCommandType.DELETE || sct == SqlCommandType.INSERT) {
            if (InterceptorIgnoreHelper.willIgnoreDataPermission((String)ms.getId())) {
                return;
            }
            this.handleInsertOrUpdateDataPms(mpSh, ms, sct);
        }
    }

    public void beforeGetBoundSql(StatementHandler sh) {
        PluginUtils.MPStatementHandler mpSh = PluginUtils.mpStatementHandler(sh);
        MappedStatement ms = mpSh.mappedStatement();
        SqlCommandType sct = ms.getSqlCommandType();
        if (sct == SqlCommandType.UPDATE || sct == SqlCommandType.INSERT) {
            if (InterceptorIgnoreHelper.willIgnoreDataPermission((String)ms.getId())) {
                return;
            }
            this.handleInsertOrUpdateDataPms(mpSh, ms, sct);
        }
    }

    private void handleInsertOrUpdateDataPms(PluginUtils.MPStatementHandler mpSh, MappedStatement ms, SqlCommandType sct) {
        PluginUtils.MPBoundSql mpBs = mpSh.mPBoundSql();
        mpBs.sql(this.parserMulti(mpBs.sql(), ms.getId()));
        try {
            Statement statement = CCJSqlParserUtil.parse((String)mpSh.mPBoundSql().sql());
            if (sct == SqlCommandType.UPDATE) {
                this.dataPermissionHandler.updateParameter((Update)statement, ms, mpSh.boundSql());
            }
            if (sct == SqlCommandType.INSERT) {
                this.dataPermissionHandler.insertParameter((Insert)statement, mpSh.boundSql());
            }
        }
        catch (UserOverreachException e) {
            throw new UserOverreachException();
        }
        catch (JSQLParserException e) {
            this.logger.error("Unexpected error for mappedStatement={}, sql={}", new Object[]{ms.getId(), mpBs.sql(), e});
        }
    }

    protected void processSelect(Select select, int index, String sql, Object obj) {
        SelectBody selectBody = select.getSelectBody();
        if (selectBody instanceof PlainSelect) {
            this.setWhere((PlainSelect)selectBody, (String)obj);
        } else if (selectBody instanceof SetOperationList) {
            SetOperationList setOperationList = (SetOperationList)selectBody;
            List selectBodyList = setOperationList.getSelects();
            selectBodyList.forEach(s -> this.setWhere((PlainSelect)s, (String)obj));
        }
    }

    protected void processInsert(Insert insert, int index, String sql, Object obj) {
    }

    protected void processDelete(Delete delete, int index, String sql, Object obj) {
        Expression sqlSegment = this.getUpdateOrDeleteExpression(delete.getTable(), delete.getWhere(), (String)obj);
        if (null != sqlSegment) {
            delete.setWhere(sqlSegment);
        }
    }

    protected void processUpdate(Update update, int index, String sql, Object obj) {
        Expression sqlSegment = this.getUpdateOrDeleteExpression(update.getTable(), update.getWhere(), (String)obj);
        if (null != sqlSegment) {
            update.setWhere(sqlSegment);
        }
    }

    protected void setWhere(PlainSelect plainSelect, String whereSegment) {
        Table table = (Table)plainSelect.getFromItem();
        Expression sqlSegment = this.dataPermissionHandler.getSqlSegment(table, plainSelect.getWhere(), whereSegment);
        if (null != sqlSegment) {
            plainSelect.setWhere(sqlSegment);
        }
    }

    protected Expression getUpdateOrDeleteExpression(Table table, Expression where, String whereSegment) {
        return this.dataPermissionHandler.getSqlSegment(table, where, whereSegment);
    }

    public Logger getLogger() {
        return this.logger;
    }

    public DataPmsHandler getDataPermissionHandler() {
        return this.dataPermissionHandler;
    }

    public void setDataPermissionHandler(DataPmsHandler dataPermissionHandler) {
        this.dataPermissionHandler = dataPermissionHandler;
    }

    public DataPmsInterceptor() {
    }

    public DataPmsInterceptor(DataPmsHandler dataPermissionHandler) {
        this.dataPermissionHandler = dataPermissionHandler;
    }

    public String toString() {
        return "DataPmsInterceptor(super=" + super.toString() + ", logger=" + this.getLogger() + ", dataPermissionHandler=" + this.getDataPermissionHandler() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataPmsInterceptor)) {
            return false;
        }
        DataPmsInterceptor other = (DataPmsInterceptor)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Logger this$logger = this.getLogger();
        Logger other$logger = other.getLogger();
        if (this$logger == null ? other$logger != null : !this$logger.equals(other$logger)) {
            return false;
        }
        DataPmsHandler this$dataPermissionHandler = this.getDataPermissionHandler();
        DataPmsHandler other$dataPermissionHandler = other.getDataPermissionHandler();
        return !(this$dataPermissionHandler == null ? other$dataPermissionHandler != null : !this$dataPermissionHandler.equals(other$dataPermissionHandler));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DataPmsInterceptor;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Logger $logger = this.getLogger();
        result = result * 59 + ($logger == null ? 43 : $logger.hashCode());
        DataPmsHandler $dataPermissionHandler = this.getDataPermissionHandler();
        result = result * 59 + ($dataPermissionHandler == null ? 43 : $dataPermissionHandler.hashCode());
        return result;
    }
}

