/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.mybatis;

import cn.allbs.mybatis.properties.MybatisProperties;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.config.GlobalConfig;
import com.baomidou.mybatisplus.core.handlers.MetaObjectHandler;
import java.nio.charset.Charset;
import java.time.LocalDateTime;
import java.util.Optional;
import org.apache.ibatis.reflection.MetaObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.util.ClassUtils;

public class MybatisPlusMetaObjectHandler
implements MetaObjectHandler {
    private static final Logger log = LoggerFactory.getLogger(MybatisPlusMetaObjectHandler.class);
    private final MybatisProperties mybatisProperties;

    public void insertFill(MetaObject metaObject) {
        log.debug("mybatis plus start insert fill ....");
        LocalDateTime now = LocalDateTime.now();
        MybatisPlusMetaObjectHandler.fillValIfNullByName(this.mybatisProperties.getMetaCustom().getCreateTime(), now, metaObject, false);
        MybatisPlusMetaObjectHandler.fillValIfNullByName(this.mybatisProperties.getMetaCustom().getUpdateTime(), now, metaObject, false);
        MybatisPlusMetaObjectHandler.fillValIfNullByName(this.mybatisProperties.getMetaCustom().getCreateName(), this.getUserName(), metaObject, false);
        MybatisPlusMetaObjectHandler.fillValIfNullByName(this.mybatisProperties.getMetaCustom().getUpdateName(), this.getUserName(), metaObject, false);
        MybatisPlusMetaObjectHandler.fillValIfNullByName(this.mybatisProperties.getMetaCustom().getDelFlg(), new GlobalConfig.DbConfig().getLogicNotDeleteValue(), metaObject, false);
    }

    public void updateFill(MetaObject metaObject) {
        MybatisPlusMetaObjectHandler.fillValIfNullByName(this.mybatisProperties.getMetaCustom().getUpdateTime(), LocalDateTime.now(), metaObject, true);
        MybatisPlusMetaObjectHandler.fillValIfNullByName(this.mybatisProperties.getMetaCustom().getUpdateName(), this.getUserName(), metaObject, true);
    }

    private static void fillValIfNullByName(String fieldName, Object fieldVal, MetaObject metaObject, boolean isCover) {
        if (fieldVal == null) {
            return;
        }
        if (!metaObject.hasSetter(fieldName)) {
            return;
        }
        Object userSetValue = metaObject.getValue(fieldName);
        String setValueStr = StrUtil.str((Object)userSetValue, (Charset)Charset.defaultCharset());
        if (StrUtil.isNotBlank((CharSequence)setValueStr) && !isCover) {
            return;
        }
        Class getterType = metaObject.getGetterType(fieldName);
        if (ClassUtils.isAssignableValue((Class)getterType, (Object)fieldVal)) {
            metaObject.setValue(fieldName, fieldVal);
            return;
        }
        if (String.class.getName().equals(getterType.getName())) {
            metaObject.setValue(fieldName, fieldVal);
            return;
        }
        if (Integer.class.getName().equals(getterType.getName())) {
            metaObject.setValue(fieldName, (Object)Integer.valueOf(fieldVal.toString()));
        }
    }

    private String getUserName() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (Optional.ofNullable(authentication).isPresent()) {
            Object principal = authentication.getPrincipal();
            if (principal instanceof String) {
                return (String)principal;
            }
            if (principal instanceof UserDetails) {
                return ((UserDetails)principal).getUsername();
            }
        }
        return null;
    }

    public MybatisPlusMetaObjectHandler(MybatisProperties mybatisProperties) {
        this.mybatisProperties = mybatisProperties;
    }
}

