/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.mybatis;

import cn.allbs.mybatis.MybatisPlusMetaObjectHandler;
import cn.allbs.mybatis.SqlFilterArgumentResolver;
import cn.allbs.mybatis.datascope.DataPmsHandler;
import cn.allbs.mybatis.datascope.DataPmsInterceptor;
import cn.allbs.mybatis.datascope.DefaultPmsHandler;
import cn.allbs.mybatis.filter.DruidSqlLogFilter;
import cn.allbs.mybatis.properties.MybatisProperties;
import com.baomidou.mybatisplus.extension.plugins.MybatisPlusInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.PaginationInnerInterceptor;
import java.util.List;
import javax.sql.DataSource;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@ConditionalOnBean(value={DataSource.class})
@AutoConfigureAfter(value={DataSourceAutoConfiguration.class})
@EnableConfigurationProperties(value={MybatisProperties.class})
public class MybatisPlusConfig
implements WebMvcConfigurer {
    @Bean
    public MybatisPlusInterceptor mybatisPlusInterceptor(MybatisProperties properties, DataPmsHandler dataPmsHandler) {
        MybatisPlusInterceptor interceptor = new MybatisPlusInterceptor();
        if (properties.isDataPms()) {
            DataPmsInterceptor dataPermissionInterceptor = new DataPmsInterceptor(dataPmsHandler);
            interceptor.addInnerInterceptor((InnerInterceptor)dataPermissionInterceptor);
        }
        interceptor.addInnerInterceptor((InnerInterceptor)new PaginationInnerInterceptor());
        return interceptor;
    }

    @Bean
    @ConditionalOnMissingBean(value={DataPmsHandler.class})
    public DataPmsHandler dataPmsHandler() {
        return new DefaultPmsHandler();
    }

    public void addArgumentResolvers(List<HandlerMethodArgumentResolver> resolverList) {
        resolverList.add(new SqlFilterArgumentResolver());
    }

    @Bean
    public DruidSqlLogFilter sqlLogFilter(MybatisProperties properties) {
        return new DruidSqlLogFilter(properties);
    }

    @Bean
    public MybatisPlusMetaObjectHandler mybatisPlusMetaObjectHandler(MybatisProperties properties) {
        return new MybatisPlusMetaObjectHandler(properties);
    }
}

