package cn.allbs.mongo.converter;

import cn.allbs.common.utils.JsonUtil;
import com.fasterxml.jackson.databind.JsonNode;
import org.bson.BasicBSONObject;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.convert.ReadingConverter;
import org.springframework.lang.Nullable;

/**
 * @author ChenQi
 */
@ReadingConverter
public enum DBObjectToJsonNodeConverter implements Converter<BasicBSONObject, JsonNode> {
    /**
     * 实例
     */
    INSTANCE;

    @Nullable
    @Override
    public JsonNode convert(@Nullable BasicBSONObject source) {
        if (source == null) {
            return null;
        }
        return JsonUtil.getInstance().valueToTree(source);
    }
}
