/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.mongo.utils;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.LinkedList;
import java.util.StringJoiner;
import org.springframework.util.Assert;

public class JsonNodeInfo {
    private final String nodeKeys;
    private final String nodePath;
    private final LinkedList<String> elements;
    private final JsonNode leafNode;

    public JsonNodeInfo(LinkedList<String> elements, JsonNode leafNode) {
        Assert.notNull(elements, (String)"elements can not be null.");
        this.nodeKeys = JsonNodeInfo.getNodeKeys(elements);
        this.nodePath = JsonNodeInfo.getNodePath(elements);
        this.elements = elements;
        this.leafNode = leafNode;
    }

    private static String getNodeKeys(LinkedList<String> elements) {
        StringJoiner nodeKeysJoiner = new StringJoiner(".");
        elements.forEach(nodeKeysJoiner::add);
        return nodeKeysJoiner.toString();
    }

    private static String getNodePath(LinkedList<String> elements) {
        StringJoiner nodePathJoiner = new StringJoiner("/", "/", "");
        elements.forEach(nodePathJoiner::add);
        return nodePathJoiner.toString();
    }

    public String getFirst() {
        return this.elements.getFirst();
    }

    public String getNodeKeys() {
        return this.nodeKeys;
    }

    public String getNodePath() {
        return this.nodePath;
    }

    public LinkedList<String> getElements() {
        return this.elements;
    }

    public JsonNode getLeafNode() {
        return this.leafNode;
    }
}

