package cn.allbs.mongo.utils;

import com.fasterxml.jackson.databind.JsonNode;
import lombok.Getter;
import org.springframework.util.Assert;

import java.util.LinkedList;
import java.util.StringJoiner;

/**
 * @author ChenQi
 */
@Getter
public class JsonNodeInfo {
    /**
     * mongo keys: class1.class2.item
     */
    private final String nodeKeys;
    /**
     * jsonPath语法：/class1/class2/item
     */
    private final String nodePath;
    /**
     * 节点关系
     */
    private final LinkedList<String> elements;
    /**
     * tree 的 叶子节点，此处为引用
     */
    private final JsonNode leafNode;

    public JsonNodeInfo(LinkedList<String> elements, JsonNode leafNode) {
        Assert.notNull(elements, "elements can not be null.");
        this.nodeKeys = getNodeKeys(elements);
        this.nodePath = getNodePath(elements);
        this.elements = elements;
        this.leafNode = leafNode;
    }

    /**
     * 获取 mongo db的 key 语法
     *
     * @return mongo db的 key 语法
     */
    private static String getNodeKeys(LinkedList<String> elements) {
        StringJoiner nodeKeysJoiner = new StringJoiner(".");
        elements.forEach(nodeKeysJoiner::add);
        return nodeKeysJoiner.toString();
    }

    /**
     * 获取 json path 语法路径
     *
     * @return jsonPath 路径
     */
    private static String getNodePath(LinkedList<String> elements) {
        StringJoiner nodePathJoiner = new StringJoiner("/", "/", "");
        elements.forEach(nodePathJoiner::add);
        return nodePathJoiner.toString();
    }

    /**
     * 获取第一个元素
     *
     * @return element
     */
    public String getFirst() {
        return elements.getFirst();
    }

}
