package cn.allbs.utils.gb26875.enums.system;

import lombok.Getter;
import lombok.RequiredArgsConstructor;

import java.util.HashMap;
import java.util.Map;

/**
 * 建筑消防设施部件状态 消息体系统类型定义
 *
 * @author ChenQi
 */
@Getter
@RequiredArgsConstructor
public enum Type2STEnum {

    /**
     * 消息体定义
     */
    _0(0, "通用"),
    _1(1, "火灾报警控制器"),
    _2(2, "预留"),
    _3(3, "预留"),
    _4(4, "预留"),
    _5(5, "预留"),
    _6(6, "预留"),
    _7(7, "预留"),
    _8(8, "预留"),
    _9(9, "预留"),
    _10(10, "可燃气体探测器"),
    _11(11, "点型可燃气体探测器"),
    _12(12, "独立式可燃气体探测器"),
    _13(13, "线型可燃气体探测器"),
    _14(14, "预留"),
    _15(15, "预留"),
    _16(16, "电气火灾监控报警器"),
    _17(17, "剩余电流式电气火灾监控探测器"),
    _18(18, "测温式电气火灾监控探测器"),
    _19(19, "预留"),
    _20(20, "预留"),
    _21(21, "探测回路"),
    _22(22, "火灾显示盘"),
    _23(23, "手动火灾报警按钮"),
    _24(24, "消火栓按钮"),

    _25(25, "火灾探测器"),

    _26(26, "预留"),

    _27(27, "预留"),

    _28(28, "预留"),

    _29(29, "预留"),

    _30(30, "感温火灾探测器"),

    _31(31, "点型感温火灾探测器"),

    _32(32, "点型感温火灾探测器(S型)"),

    _33(33, "点型感温火灾探测器(R 型)"),

    _34(34, "线型感温火灾探测器"),

    _35(35, "线型感温火灾探测器(S型)"),

    _36(36, "线型感温火灾探测器(R 型)"),

    _37(37, "光纤感温火灾探测器"),

    _38(38, "预留"),

    _39(39, "预留"),

    _40(40, "感烟火灾探测器"),

    _41(41, "点型离子感烟火灾探测器"),

    _42(42, "点型光电感烟火灾探测器"),

    _43(43, "线型光束感烟火灾探测器"),

    _44(44, "吸气式感烟火灾探测器"),

    _45(45, "预留"),

    _46(46, "预留"),

    _47(47, "预留"),

    _48(48, "预留"),

    _49(49, "预留"),

    _50(50, "复合式火灾探测器"),

    _51(51, "复合式感烟感温火灾探测器"),

    _52(52, "复合式感光感温火灾探测器"),

    _53(53, "复合式感光感烟火灾探测器"),

    _54(54, "预留"),

    _55(55, "预留"),

    _56(56, "预留"),

    _57(57, "预留"),

    _58(58, "预留"),

    _59(59, "预留"),

    _60(60, "预留"),

    _61(61, "紫外火焰探测器"),

    _62(62, "红外火焰探测器"),

    _63(63, "预留"),

    _64(64, "预留"),

    _65(65, "预留"),

    _66(66, "预留"),

    _67(67, "预留"),

    _68(68, "预留"),

    _69(69, "感光火灾探测器"),

    _70(70, "预留"),

    _71(71, "预留"),

    _72(72, "预留"),

    _73(73, "预留"),

    _74(74, "气体探测器"),

    _75(75, "预留"),

    _76(76, "预留"),

    _77(77, "预留"),

    _78(78, "图像摄像方式火灾探测器"),

    _79(79, "感声火灾探测器"),

    _80(80, "预留"),

    _81(81, "气体灭火控制器"),

    _82(82, "消防电气控制装置"),

    _83(83, "消防控制室图形显示装置"),

    _84(84, "模块"),

    _85(85, "输入模块"),

    _86(86, "输出模块"),

    _87(87, "输入/输出模块"),

    _88(88, "中继模块"),

    _89(89, "预留"),

    _90(90, "预留"),

    _91(91, "消防水泵"),

    _92(92, "消防水箱"),

    _93(93, "预留"),

    _94(94, "预留"),

    _95(95, "喷淋泵"),

    _96(96, "水流指示器"),

    _97(97, "信号阀"),

    _98(98, "报警阀"),

    _99(99, "压力开关"),

    _100(100, "预留"),

    _101(101, "阀驱动装置"),

    _102(102, "防火门"),

    _103(103, "防火阀"),

    _104(104, "通风空调"),

    _105(105, "泡沫液泵"),

    _106(106, "管网电磁阀"),

    _107(107, "预留"),

    _108(108, "预留"),

    _109(109, "预留"),

    _110(110, "预留"),

    _111(111, "防烟排烟风机"),

    _112(112, "预留"),

    _113(113, "排烟防火阀"),

    _114(114, "常闭送风口"),

    _115(115, "排烟口"),

    _116(116, "电控挡烟垂壁"),

    _117(117, "防火卷帘控制器"),

    _118(118, "防火门监控器"),

    _119(119, "预留"),

    _120(120, "预留"),

    _121(121, "警报装置");


    private final int type;

    private final String trans;

    public static final Map<Short, String> TYPE_2_MAP = new HashMap<>();

    static {
        Type2STEnum[] enums = Type2STEnum.values();
        for (Type2STEnum item : enums) {
            TYPE_2_MAP.put((short) item.getType(), item.getTrans());
        }
    }
}
