/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.utils;

public final class PoolFireUtil {
    public static Double mudan(double s, double h, double x, double n, double m, double d, double hc) {
        double t = 1.0 - 0.058 * Math.log(x);
        double a = (Math.pow(h, 2.0) + Math.pow(s, 2.0) + 1.0) / (2.0 * s);
        double b = (1.0 + Math.pow(s, 2.0)) / (2.0 * s);
        double sqrt = (a + 1.0) * (s - 1.0) / (a - 1.0) / (s + 1.0);
        double fh = 0.3183098861837907 * ((b - 1.0 / s) / Math.sqrt(Math.pow(b, 2.0) - 1.0) * Math.tan(-1.0) * Math.sqrt((b + 1.0) * (s - 1.0) / ((b - 1.0) * (s + 1.0))) - (a - 1.0 / s) / Math.sqrt(Math.pow(a, 2.0) - 1.0) * Math.tan(-1.0) * Math.sqrt(sqrt));
        double fv = 0.3183098861837907 * (1.0 / s * Math.tan(-1.0) * h / Math.sqrt(Math.pow(s, 2.0) - 1.0) + h / s * (Math.tan(-1.0) * Math.sqrt((s - 1.0) / (s + 1.0)) - a / Math.sqrt(Math.pow(a, 2.0) - 1.0) * Math.tan(-1.0) * Math.sqrt(sqrt)));
        double f = Math.sqrt(Math.pow(fh, 2.0) + Math.pow(fv, 2.0));
        return 0.7853981633974483 * Math.pow(d, 2.0) * n * m * hc / (0.7853981633974483 * Math.pow(d, 2.0) + Math.PI * d * h) * f * t;
    }

    public static Double mf(double hc, double cp, double tb, double t0, double h) {
        return 0.001 * hc / (cp * (tb - t0) + h);
    }

    public static Double fireHeightWithoutWind(double m, double p0, double g, double d) {
        return 42.0 * d * Math.pow(m / (p0 * Math.sqrt(g * d)), 0.61);
    }

    public static Double fireHeightWithWind(double m, double p0, double g, double d, double u, double pv) {
        double uf = u / Math.pow(g * m * d / pv, 0.3333333432674408);
        return 55.0 * d * Math.pow(m / (p0 * Math.sqrt(g * d)), 0.67) * Math.pow(uf, -0.21);
    }

    public static Double countWithoutWind(double n, double hc, double x, double m, double p0, double g, double d) {
        double hei = PoolFireUtil.fireHeightWithoutWind(m, p0, g, d);
        double h = 2.0 * hei / d;
        double s = 2.0 * x / d;
        return PoolFireUtil.mudan(s, h, x, n, m, d, hc);
    }

    public static Double countWithWind(double n, double hc, double x, double m, double p0, double g, double d, double u, double pv) {
        double hei = PoolFireUtil.fireHeightWithWind(m, p0, g, d, u, pv);
        double h = 2.0 * hei / d;
        double s = 2.0 * x / d;
        return PoolFireUtil.mudan(s, h, x, n, m, d, hc);
    }

    public static Double thermalRadiationFlux(double d, double h, double v, double n, double hc) {
        double r = d / 2.0;
        return (Math.PI * Math.pow(r, 2.0) + Math.PI * 2 * r * h) * v * n * hc / (72.0 * Math.pow(v, 0.6) + 1.0);
    }

    public static Double heatRadiationIntensity(double q, double tc, double x) {
        return q * tc / (Math.PI * 4 * Math.pow(x, 2.0));
    }

    public static Double count(double n, double hc, double x, double m, double p0, double g, double d) {
        double fh = PoolFireUtil.fireHeightWithoutWind(m, p0, g, d);
        double q = PoolFireUtil.thermalRadiationFlux(d, fh, m, n, hc);
        return PoolFireUtil.heatRadiationIntensity(q, 1.0, x);
    }

    public static Double x(double q, double tc, double i) {
        return Math.sqrt(q * tc / (Math.PI * 4 * i));
    }

    private PoolFireUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

