/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.utils;

import cn.allbs.model.EarthPoint3D;
import cn.allbs.model.Point3D;
import cn.allbs.model.SpacePoint;
import cn.allbs.utils.EvaporationUtil;
import cn.allbs.utils.GaussUtil;
import cn.allbs.utils.HorizontalJetFireUtil;
import cn.allbs.utils.LngLatUtil;
import cn.allbs.utils.PoolFireUtil;
import cn.allbs.utils.SpaceGeometryUtil;
import cn.allbs.utils.VaporCloudExplosionUtil;
import cn.allbs.utils.VesselExplosionUtil;
import cn.allbs.utils.WGS84MercatorToLngLatUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.ObjectUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class ModelUtil {
    public static Set<SpacePoint> poolFire(double g, double p0, double n, double hc, double m, double d, double lng, double lat, double height, double distance, double extendDistance) {
        Point3D centerPoint = new Point3D(lng, lat, height);
        HashSet<SpacePoint> poolFirePoints = new HashSet<SpacePoint>();
        Set<Point3D> points = SpaceGeometryUtil.earthBatchPeak(centerPoint, distance, extendDistance);
        points.forEach(a -> {
            if (a.getZ() < 0.0) {
                a.setZ(0.0);
            }
            double x = LngLatUtil.getDistance(a.getX(), a.getY(), centerPoint.getX(), centerPoint.getY());
            double c = PoolFireUtil.count(n, hc, x, m, p0, g, d);
            poolFirePoints.add(new SpacePoint((Point3D)a, c));
        });
        return poolFirePoints;
    }

    public static Set<SpacePoint> horizontalFire(double hc, double m, double lng, double lat, double height, double distance, double extendDistance) {
        Point3D centerPoint = new Point3D(lng, lat, height);
        HashSet<SpacePoint> poolFirePoints = new HashSet<SpacePoint>();
        Set<Point3D> points = SpaceGeometryUtil.earthBatchPeak(centerPoint, distance, extendDistance);
        points.forEach(a -> {
            if (a.getZ() < 0.0) {
                a.setZ(0.0);
            }
            double x = LngLatUtil.getDistance(a.getX(), a.getY(), centerPoint.getX(), centerPoint.getY());
            double c = HorizontalJetFireUtil.count(hc, x, m);
            poolFirePoints.add(new SpacePoint((Point3D)a, c));
        });
        return poolFirePoints;
    }

    public static Set<SpacePoint> vesselExplosion(double p, double v, double lng, double lat, double height, double distance, double extendDistance) {
        Point3D centerPoint = new Point3D(lng, lat, height);
        HashSet<SpacePoint> poolFirePoints = new HashSet<SpacePoint>();
        Set<Point3D> points = SpaceGeometryUtil.earthBatchPeak(centerPoint, distance, extendDistance);
        points.forEach(a -> {
            if (a.getZ() < 0.0) {
                a.setZ(0.0);
            }
            double x = LngLatUtil.getDistance(a.getX(), a.getY(), centerPoint.getX(), centerPoint.getY());
            double c = VesselExplosionUtil.count(p, v, x);
            poolFirePoints.add(new SpacePoint((Point3D)a, c));
        });
        return poolFirePoints;
    }

    public static Set<SpacePoint> vaporCloudExplosion(Double qm, Double cp, Double tt, Double tb, Double hv, Double a1, Double t0, Double h, Double t, Double u, Double r, Double m, Double t1, Double t2, Double t3, double q, double lng, double lat, double height, double distance, double extendDistance) {
        Point3D centerPoint = new Point3D(lng, lat, height);
        HashSet<SpacePoint> poolFirePoints = new HashSet<SpacePoint>();
        Set<Point3D> points = SpaceGeometryUtil.earthBatchPeak(centerPoint, distance, extendDistance);
        points.forEach(a -> {
            if (a.getZ() < 0.0) {
                a.setZ(0.0);
            }
            double x = LngLatUtil.getDistance(a.getX(), a.getY(), centerPoint.getX(), centerPoint.getY());
            double w = EvaporationUtil.totalEvaporation(qm, cp, tt, tb, hv, a1, t0, h, t, u, r, m, t1, t2, t3);
            double c = VaporCloudExplosionUtil.count(w, q, x);
            poolFirePoints.add(new SpacePoint((Point3D)a, c));
        });
        return poolFirePoints;
    }

    public static Set<SpacePoint> gaussSmokeRegiment(double ws, double t, double q, double angle, double lng, double lat, double height, double distance, double step) {
        Point3D centerPoint = new Point3D(lng, lat, height);
        HashSet<SpacePoint> poolFirePoints = new HashSet<SpacePoint>();
        Set<EarthPoint3D> points = SpaceGeometryUtil.totalEarthBatchPeakDetailWithoutWd(centerPoint, distance, angle, step);
        points.forEach(a -> {
            if (a.getHeight() < 0.0) {
                a.setZ(-(distance + a.getHeight()));
                a.setHeight(0.0);
            }
            if (a.getX() == 0.0) {
                return;
            }
            double c = NumberUtil.round((double)GaussUtil.smokeConcentration(q, ws, t, Math.abs(a.getX()), Math.abs(a.getY()), Math.abs(a.getZ())), (int)3).doubleValue();
            if (ObjectUtil.isNotNull((Object)c) && c != 0.0) {
                poolFirePoints.add(new SpacePoint((EarthPoint3D)a, c));
            }
        });
        return poolFirePoints;
    }

    public static Set<SpacePoint> gaussPlumeWithFactor(double ws, double q, Integer l, double angle, double h, double lng, double lat, double height, double distance, double step) {
        Point3D centerPoint = new Point3D(lng, lat, height);
        HashSet<SpacePoint> poolFirePoints = new HashSet<SpacePoint>();
        Set<EarthPoint3D> points = SpaceGeometryUtil.EarthBatchPeakDetailToWd(centerPoint, distance, angle, step);
        points.forEach(a -> {
            if (a.getHeight() < 0.0) {
                a.setZ(-(distance + a.getHeight()));
                a.setHeight(0.0);
                double c = NumberUtil.round((double)GaussUtil.allGroundReflection(q, ws, h, a.getX(), Math.abs(a.getY()), l), (int)3).doubleValue();
                poolFirePoints.add(new SpacePoint((EarthPoint3D)a, c));
            } else {
                double c = NumberUtil.round((double)GaussUtil.highPowerContinuousDiffusion(q, ws, h, a.getX(), Math.abs(a.getY()), a.getZ(), l), (int)3).doubleValue();
                poolFirePoints.add(new SpacePoint((EarthPoint3D)a, c));
            }
        });
        return poolFirePoints;
    }

    public static Set<SpacePoint> gaussPlumeWithoutFactor(double q, double u, double angle, double h, double lng, double lat, double distance, double step) {
        Point3D centerPoint = new Point3D(lng, lat, h);
        HashSet<SpacePoint> poolFirePoints = new HashSet<SpacePoint>();
        Set<EarthPoint3D> points = SpaceGeometryUtil.EarthBatchPeakDetailToWd(centerPoint, distance, angle, step);
        points.forEach(a -> {
            double c;
            if (a.getHeight() < 0.0) {
                a.setZ(-(distance + a.getHeight()));
                a.setHeight(0.0);
            }
            if ((c = NumberUtil.round((double)GaussUtil.powerContinuousDiffusionWithoutSigma(q, u, h, Math.abs(a.getX()), Math.abs(a.getY()), Math.abs(a.getZ())), (int)3).doubleValue()) != 0.0) {
                poolFirePoints.add(new SpacePoint((EarthPoint3D)a, c));
            }
        });
        return poolFirePoints;
    }

    public static List<Map<String, Object>> gaussPlumeWithoutFactor(Double q, Double ce, Double se, Double h, Double[] ue, Integer step, Double z) {
        HashMap<String, Number> levLngLatMap;
        Double[] spreadRotateLnglat;
        Double[] spreadLnglat;
        Double[] spreadMercator;
        Double ie;
        Integer currLevel;
        int o;
        Double ne;
        int a;
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        if (ue != null ? se > 360.0 || se < 0.0 : ce == null || ce < 0.0) {
            return null;
        }
        Double[] originMercator = WGS84MercatorToLngLatUtil.lonLatToMercator(ue[1], ue[0]);
        for (a = 0; a <= 10000; a += step.intValue()) {
            ne = Convert.toDouble((Object)a);
            for (o = 0; o <= 2000 && (currLevel = ModelUtil.calculate2(q, ne, ie = Convert.toDouble((Object)o), z, h, ce, 0.0)) > 0; o += step.intValue()) {
                spreadMercator = new Double[]{originMercator[0] + ne, originMercator[1] + ie};
                spreadLnglat = WGS84MercatorToLngLatUtil.mercatorToLonLat(spreadMercator[0], spreadMercator[1]);
                spreadRotateLnglat = LngLatUtil.route(ue, spreadLnglat, se);
                levLngLatMap = new HashMap<String, Number>();
                levLngLatMap.put("level", currLevel);
                levLngLatMap.put("lng", spreadRotateLnglat[0]);
                levLngLatMap.put("lat", spreadRotateLnglat[1]);
                levLngLatMap.put("height", z);
                result.add(levLngLatMap);
            }
        }
        for (a = 0; a <= 10000; a += step.intValue()) {
            ne = Convert.toDouble((Object)a);
            for (o = -step.intValue(); o >= -4000 && (currLevel = ModelUtil.calculate2(q, ne, ie = Convert.toDouble((Object)o), z, h, ce, 0.0)) > 0; o -= step.intValue()) {
                spreadMercator = new Double[]{originMercator[0] + ne, originMercator[1] + ie};
                spreadLnglat = WGS84MercatorToLngLatUtil.mercatorToLonLat(spreadMercator[0], spreadMercator[1]);
                spreadRotateLnglat = LngLatUtil.route(ue, spreadLnglat, se);
                levLngLatMap = new HashMap();
                levLngLatMap.put("level", currLevel);
                levLngLatMap.put("lng", spreadRotateLnglat[0]);
                levLngLatMap.put("lat", spreadRotateLnglat[1]);
                levLngLatMap.put("height", z);
                result.add(0, levLngLatMap);
            }
        }
        return result;
    }

    public static Integer calSpread(double q, Double[] ue, Double[] originMercator, double x, double y, double ce, Double se, int s, double h) {
        Double n = GaussUtil.powerContinuousDiffusionWithoutSigma(q, ce, h, x, y, h);
        int level = ModelUtil.calLevel(n);
        return level;
    }

    public static Integer calculate2(Double Q, Double x, Double y, Double z, Double h, Double u, Double t) {
        Object[] spreadArray = new Double[0];
        Double a = ArrayUtil.isNotEmpty((Object[])spreadArray) ? (Double)spreadArray[0] : 0.527;
        Double b = ArrayUtil.isNotEmpty((Object[])spreadArray) ? (Double)spreadArray[1] : 0.865;
        Double c = ArrayUtil.isNotEmpty((Object[])spreadArray) ? (Double)spreadArray[2] : 0.28;
        Double d = ArrayUtil.isNotEmpty((Object[])spreadArray) ? (Double)spreadArray[3] : 0.9;
        Double \u03c3y = a * Math.pow(x, b);
        Double \u03c3z = c * Math.pow(x, d);
        Double \u03c3x = \u03c3y;
        Double C = Q / (Math.pow(Math.PI * 2, 1.0) * \u03c3x * \u03c3y * \u03c3z) * Math.exp(-(Math.pow(y, 2.0) / (2.0 * Math.pow(\u03c3y, 2.0)))) * (Math.exp(-(Math.pow(z - h, 2.0) / (2.0 * Math.pow(\u03c3z, 2.0)))) + Math.exp(-(Math.pow(z + h, 2.0) / (2.0 * Math.pow(\u03c3z, 2.0))))) * Math.exp(-(Math.pow(x - u * t, 2.0) / Math.pow(2.0 * \u03c3x, 2.0)));
        int level = ModelUtil.calLevel(C);
        return level;
    }

    public static int calLevel(double aa) {
        aa *= 1000.0;
        Double[] ge = new Double[]{1.5, 18.0, 90.0, 180.0, 300.0, 3000.0};
        int level = 0;
        for (int r = 0; r < ge.length; ++r) {
            if (0 == r) {
                if (!(aa < ge[r + 1]) || !(aa >= ge[r])) continue;
                level = r;
                continue;
            }
            if (r == ge.length - 1) {
                if (!(aa >= ge[r])) continue;
                level = r;
                continue;
            }
            if (!(aa < ge[r + 1]) || !(aa >= ge[r])) continue;
            level = r;
        }
        return level;
    }

    private ModelUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

