/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.utils;

import cn.allbs.enums.MathExtentEnum;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;

public final class IntervalUtil {
    public static boolean isInTheInterval(String dataValue, String interval) {
        String formula = IntervalUtil.getFormulaByAllInterval(dataValue, interval);
        ScriptEngine jse = new ScriptEngineManager().getEngineByName("JavaScript");
        try {
            return (Boolean)jse.eval(formula);
        }
        catch (Exception t) {
            return false;
        }
    }

    private static String getFormulaByAllInterval(String dataValue, String interval) {
        StringBuilder buff = new StringBuilder();
        for (String limit : interval.split("U")) {
            buff.append("(").append(IntervalUtil.getFormulaByInterval(dataValue, limit)).append(")").append("||");
        }
        String allLimitIntel = buff.toString();
        int index = allLimitIntel.lastIndexOf("||");
        allLimitIntel = allLimitIntel.substring(0, index);
        return allLimitIntel;
    }

    private static String getFormulaByInterval(String dataValue, String interval) {
        StringBuilder buff = new StringBuilder();
        for (String halfInterval : interval.split(",")) {
            buff.append(IntervalUtil.getFormulaByHalfInterval(halfInterval, dataValue)).append(" && ");
        }
        String limitIntel = buff.toString();
        int index = limitIntel.lastIndexOf(" && ");
        limitIntel = limitIntel.substring(0, index);
        return limitIntel;
    }

    private static String getFormulaByHalfInterval(String halfInterval, String dateValue) {
        String data;
        String opera;
        if ((halfInterval = halfInterval.trim()).contains("\u221e")) {
            return "1 == 1";
        }
        StringBuilder formula = new StringBuilder();
        if (halfInterval.matches("^([<>\u2264\u2265\\[(]{1}(-?\\d+.?\\d*%?))$")) {
            opera = halfInterval.substring(0, 1);
            data = halfInterval.substring(1);
        } else {
            opera = halfInterval.substring(halfInterval.length() - 1);
            data = halfInterval.substring(0, halfInterval.length() - 1);
        }
        double value = IntervalUtil.dealPercent(data);
        formula.append(dateValue).append(" ").append(opera).append(" ").append(value);
        String a = formula.toString();
        return a.replace("[", ">=").replace("(", ">").replace("]", "<=").replace(")", "<").replace("\u2264", "<=").replace("\u2265", ">=");
    }

    private static double dealPercent(String str) {
        double d;
        if (str.contains("%")) {
            str = str.substring(0, str.length() - 1);
            d = Double.parseDouble(str) / 100.0;
        } else {
            d = Double.parseDouble(str);
        }
        return d;
    }

    public static boolean checkInAllCloseInterval(Double min, Double max, Double checkNum) {
        if (checkNum == null) {
            return true;
        }
        return IntervalUtil.isInTheInterval(checkNum.toString(), MathExtentEnum.getEqExpressAllClose(min, max));
    }

    public static boolean checkInAllOpenInterval(Double min, Double max, Double checkNum) {
        if (checkNum == null) {
            return true;
        }
        return IntervalUtil.isInTheInterval(checkNum.toString(), MathExtentEnum.getEqExpressAllOpen(min, max));
    }

    public static boolean checkInLeftCloseInterval(Double min, Double max, Double checkNum) {
        if (checkNum == null) {
            return true;
        }
        return IntervalUtil.isInTheInterval(checkNum.toString(), MathExtentEnum.getEqExpressRightOpenOnly(min, max));
    }

    public static boolean checkInRightCloseInterval(Double min, Double max, Double checkNum) {
        if (checkNum == null) {
            return true;
        }
        return IntervalUtil.isInTheInterval(checkNum.toString(), MathExtentEnum.getEqExpressLeftOpenOnly(min, max));
    }

    private IntervalUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

