/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.model;

import cn.allbs.model.Point3D;
import javafx.beans.NamedArg;

public class Point2D {
    public static final Point2D ZERO = new Point2D(0.0, 0.0);
    private double x;
    private double y;
    private int hash = 0;

    public final double getX() {
        return this.x;
    }

    public final double getY() {
        return this.y;
    }

    public Point2D(@NamedArg(value="x") double x, @NamedArg(value="y") double y) {
        this.x = x;
        this.y = y;
    }

    public double distance(double x1, double y1) {
        double a = this.getX() - x1;
        double b = this.getY() - y1;
        return Math.sqrt(a * a + b * b);
    }

    public double distance(Point2D point) {
        return this.distance(point.getX(), point.getY());
    }

    public Point2D add(double x, double y) {
        return new Point2D(this.getX() + x, this.getY() + y);
    }

    public Point2D add(Point2D point) {
        return this.add(point.getX(), point.getY());
    }

    public Point2D subtract(double x, double y) {
        return new Point2D(this.getX() - x, this.getY() - y);
    }

    public Point2D multiply(double factor) {
        return new Point2D(this.getX() * factor, this.getY() * factor);
    }

    public Point2D subtract(Point2D point) {
        return this.subtract(point.getX(), point.getY());
    }

    public Point2D normalize() {
        double mag = this.magnitude();
        if (mag == 0.0) {
            return new Point2D(0.0, 0.0);
        }
        return new Point2D(this.getX() / mag, this.getY() / mag);
    }

    public Point2D midpoint(double x, double y) {
        return new Point2D(x + (this.getX() - x) / 2.0, y + (this.getY() - y) / 2.0);
    }

    public Point2D midpoint(Point2D point) {
        return this.midpoint(point.getX(), point.getY());
    }

    public double angle(double x, double y) {
        double ay;
        double ax = this.getX();
        double delta = (ax * x + (ay = this.getY()) * y) / Math.sqrt((ax * ax + ay * ay) * (x * x + y * y));
        if (delta > 1.0) {
            return 0.0;
        }
        if (delta < -1.0) {
            return 180.0;
        }
        return Math.toDegrees(Math.acos(delta));
    }

    public double angle(Point2D point) {
        return this.angle(point.getX(), point.getY());
    }

    public double angle(Point2D p1, Point2D p2) {
        double by;
        double x = this.getX();
        double y = this.getY();
        double ax = p1.getX() - x;
        double ay = p1.getY() - y;
        double bx = p2.getX() - x;
        double delta = (ax * bx + ay * (by = p2.getY() - y)) / Math.sqrt((ax * ax + ay * ay) * (bx * bx + by * by));
        if (delta > 1.0) {
            return 0.0;
        }
        if (delta < -1.0) {
            return 180.0;
        }
        return Math.toDegrees(Math.acos(delta));
    }

    public double magnitude() {
        double x = this.getX();
        double y = this.getY();
        return Math.sqrt(x * x + y * y);
    }

    public double dotProduct(double x, double y) {
        return this.getX() * x + this.getY() * y;
    }

    public double dotProduct(Point2D vector) {
        return this.dotProduct(vector.getX(), vector.getY());
    }

    public Point3D crossProduct(double x, double y) {
        double ax = this.getX();
        double ay = this.getY();
        return new Point3D(0.0, 0.0, ax * y - ay * x);
    }

    public Point3D crossProduct(Point2D vector) {
        return this.crossProduct(vector.getX(), vector.getY());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Point2D) {
            Point2D other = (Point2D)obj;
            return this.getX() == other.getX() && this.getY() == other.getY();
        }
        return false;
    }

    public int hashCode() {
        if (this.hash == 0) {
            long bits = 7L;
            bits = 31L * bits + Double.doubleToLongBits(this.getX());
            bits = 31L * bits + Double.doubleToLongBits(this.getY());
            this.hash = (int)(bits ^ bits >> 32);
        }
        return this.hash;
    }

    public String toString() {
        return "Point2D [x = " + this.getX() + ", y = " + this.getY() + "]";
    }
}

