/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.enums;

import cn.hutool.core.util.StrUtil;

public enum MathExtentEnum {
    NO_LIMIT("(-\u221e, +\u221e)=R", "1=1"),
    IN_SECTION_LEFT_RIGHT("[a,b]:{x\u2208R:a\u2264x\u2264b}", "[{},{}]"),
    IN_SECTION_LEFT_ONLY("[a,b)={x\u2208R:a\u2264x<b}", "[{},{})"),
    IN_SECTION_RIGHT_ONLY("(a,b]={x\u2208R:a<x\u2264b}", "({},{}]"),
    IN_SECTION("(a,b)={x\u2208R:a<x<b}", "({},{})"),
    LEFT_CLOSED("[a,+\u221e)={x\u2208R:x\u2265a}", "[{},+\u221e)"),
    LEFT_OPEN("(a,+\u221e)={x\u2208R:x>a}", "({},+\u221e)"),
    RIGHT_CLOSED("(-\u221e, b]={x\u2208R:x\u2264b}", "(-\u221e, {}]"),
    RIGHT_OPEN("(-\u221e, b)={x\u2208R:x<b}", "(-\u221e, {})");

    private final String pattern;
    private final String expression;

    public static String getEqExpressAllClose(Double min, Double max) {
        if (min != null && max != null) {
            return StrUtil.format((CharSequence)IN_SECTION_LEFT_RIGHT.getExpression(), (Object[])new Object[]{min, max});
        }
        if (min != null) {
            return StrUtil.format((CharSequence)LEFT_CLOSED.getExpression(), (Object[])new Object[]{min});
        }
        if (max != null) {
            return StrUtil.format((CharSequence)RIGHT_CLOSED.getExpression(), (Object[])new Object[]{max});
        }
        return NO_LIMIT.getExpression();
    }

    public static String getEqExpressAllOpen(Double min, Double max) {
        if (min != null && max != null) {
            return StrUtil.format((CharSequence)IN_SECTION.getExpression(), (Object[])new Object[]{min, max});
        }
        if (min != null) {
            return StrUtil.format((CharSequence)LEFT_OPEN.getExpression(), (Object[])new Object[]{min});
        }
        if (max != null) {
            return StrUtil.format((CharSequence)RIGHT_OPEN.getExpression(), (Object[])new Object[]{max});
        }
        return NO_LIMIT.getExpression();
    }

    public static String getEqExpressLeftOpenOnly(Double min, Double max) {
        if (min != null && max != null) {
            return StrUtil.format((CharSequence)IN_SECTION_RIGHT_ONLY.getExpression(), (Object[])new Object[]{min, max});
        }
        if (min != null) {
            return StrUtil.format((CharSequence)LEFT_OPEN.getExpression(), (Object[])new Object[]{min});
        }
        if (max != null) {
            return StrUtil.format((CharSequence)RIGHT_CLOSED.getExpression(), (Object[])new Object[]{max});
        }
        return NO_LIMIT.getExpression();
    }

    public static String getEqExpressRightOpenOnly(Double min, Double max) {
        if (min != null && max != null) {
            return StrUtil.format((CharSequence)IN_SECTION_LEFT_ONLY.getExpression(), (Object[])new Object[]{min, max});
        }
        if (min != null) {
            return StrUtil.format((CharSequence)LEFT_CLOSED.getExpression(), (Object[])new Object[]{min});
        }
        if (max != null) {
            return StrUtil.format((CharSequence)RIGHT_OPEN.getExpression(), (Object[])new Object[]{max});
        }
        return NO_LIMIT.getExpression();
    }

    public String getPattern() {
        return this.pattern;
    }

    public String getExpression() {
        return this.expression;
    }

    private MathExtentEnum(String pattern, String expression) {
        this.pattern = pattern;
        this.expression = expression;
    }
}

