/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.utils;

import cn.allbs.constant.ParamConstant;
import java.awt.Color;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import javax.imageio.ImageIO;

public final class ImageToAsciiUtil {
    public static void printImage(BufferedImage image) {
        if (image == null) {
            return;
        }
        int width = image.getWidth();
        int height = image.getHeight();
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < width; ++j) {
                int rgb = image.getRGB(j, i);
                Color color = new Color(rgb);
                int red = color.getRed();
                int green = color.getGreen();
                int blue = color.getBlue();
                double lu = 0.2126 * (double)red + 0.7152 * (double)green + 0.0722 * (double)blue;
                double index = lu / (Math.ceil(255.0f / (float)ParamConstant.PIXEL.length) + 0.5);
                System.out.print(ParamConstant.PIXEL[(int)Math.floor(index)]);
            }
            System.out.println();
        }
    }

    public static BufferedImage makeSmallImage(String srcImageName) {
        return ImageToAsciiUtil.makeSmallImage(srcImageName, 25, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static BufferedImage makeSmallImage(String srcImageName, int dstMaxSize, int widthBlowRate) {
        File srcImageFile = new File(srcImageName);
        BufferedImage tagImage = null;
        BufferedImage srcImage = null;
        try {
            BufferedImage bufferedImage;
            Throwable throwable;
            FileOutputStream fileOutputStream;
            block18: {
                block19: {
                    fileOutputStream = null;
                    throwable = null;
                    srcImage = ImageIO.read(srcImageFile);
                    int srcWidth = ((Image)srcImage).getWidth(null);
                    int srcHeight = ((Image)srcImage).getHeight(null);
                    int dstWidth = srcWidth;
                    int dstHeight = srcHeight;
                    if (srcHeight > dstMaxSize) {
                        float rate = (float)dstMaxSize / (float)srcHeight;
                        dstHeight = dstMaxSize;
                        dstWidth = Math.round((float)dstWidth * rate) * widthBlowRate;
                    }
                    tagImage = new BufferedImage(dstWidth, dstHeight, 1);
                    tagImage.getGraphics().drawImage(srcImage, 0, 0, dstWidth, dstHeight, null);
                    bufferedImage = tagImage;
                    if (fileOutputStream == null) break block18;
                    if (throwable == null) break block19;
                    try {
                        fileOutputStream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block18;
                }
                fileOutputStream.close();
            }
            return bufferedImage;
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (fileOutputStream != null) {
                            if (throwable != null) {
                                try {
                                    fileOutputStream.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                fileOutputStream.close();
                            }
                        }
                        throw throwable4;
                    }
                }
                catch (Exception e) {
                    System.out.println("\u8f6c\u6362\u5931\u8d25" + e.getLocalizedMessage());
                }
            }
        }
        finally {
            System.gc();
        }
        return null;
    }

    private ImageToAsciiUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

