/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.utils;

public final class GPSConverterUtils {
    private static final double a = 6378137.0;
    static double x_pi = 52.35987755982988;
    static double ee = 0.006693421622965943;

    public static double[] bd09towgs84(double lng, double lat) {
        double[] gcj = GPSConverterUtils.bd09togcj02(lng, lat);
        double[] wgs84 = GPSConverterUtils.gcj02towgs84(gcj[0], gcj[1]);
        return wgs84;
    }

    public static double[] wgs84tobd09(double lng, double lat) {
        double[] gcj = GPSConverterUtils.wgs84togcj02(lng, lat);
        double[] bd09 = GPSConverterUtils.gcj02tobd09(gcj[0], gcj[1]);
        return bd09;
    }

    public static double[] gcj02tobd09(double lng, double lat) {
        double z = Math.sqrt(lng * lng + lat * lat) + 2.0E-5 * Math.sin(lat * x_pi);
        double theta = Math.atan2(lat, lng) + 3.0E-6 * Math.cos(lng * x_pi);
        double bd_lng = z * Math.cos(theta) + 0.0065;
        double bd_lat = z * Math.sin(theta) + 0.006;
        return new double[]{bd_lng, bd_lat};
    }

    public static double[] bd09togcj02(double bd_lon, double bd_lat) {
        double x = bd_lon - 0.0065;
        double y = bd_lat - 0.006;
        double z = Math.sqrt(x * x + y * y) - 2.0E-5 * Math.sin(y * x_pi);
        double theta = Math.atan2(y, x) - 3.0E-6 * Math.cos(x * x_pi);
        double gg_lng = z * Math.cos(theta);
        double gg_lat = z * Math.sin(theta);
        return new double[]{gg_lng, gg_lat};
    }

    public static double[] wgs84togcj02(double lng, double lat) {
        if (GPSConverterUtils.out_of_china(lng, lat)) {
            return new double[]{lng, lat};
        }
        double dlat = GPSConverterUtils.transformlat(lng - 105.0, lat - 35.0);
        double dlng = GPSConverterUtils.transformlng(lng - 105.0, lat - 35.0);
        double radlat = lat / 180.0 * Math.PI;
        double magic = Math.sin(radlat);
        magic = 1.0 - ee * magic * magic;
        double sqrtmagic = Math.sqrt(magic);
        dlat = dlat * 180.0 / (6378137.0 * (1.0 - ee) / (magic * sqrtmagic) * Math.PI);
        dlng = dlng * 180.0 / (6378137.0 / sqrtmagic * Math.cos(radlat) * Math.PI);
        double mglat = lat + dlat;
        double mglng = lng + dlng;
        return new double[]{mglng, mglat};
    }

    public static double[] gcj02towgs84(double lng, double lat) {
        if (GPSConverterUtils.out_of_china(lng, lat)) {
            return new double[]{lng, lat};
        }
        double dlat = GPSConverterUtils.transformlat(lng - 105.0, lat - 35.0);
        double dlng = GPSConverterUtils.transformlng(lng - 105.0, lat - 35.0);
        double radlat = lat / 180.0 * Math.PI;
        double magic = Math.sin(radlat);
        magic = 1.0 - ee * magic * magic;
        double sqrtmagic = Math.sqrt(magic);
        dlat = dlat * 180.0 / (6378137.0 * (1.0 - ee) / (magic * sqrtmagic) * Math.PI);
        dlng = dlng * 180.0 / (6378137.0 / sqrtmagic * Math.cos(radlat) * Math.PI);
        double mglat = lat + dlat;
        double mglng = lng + dlng;
        return new double[]{lng * 2.0 - mglng, lat * 2.0 - mglat};
    }

    public static double transformlat(double lng, double lat) {
        double ret = -100.0 + 2.0 * lng + 3.0 * lat + 0.2 * lat * lat + 0.1 * lng * lat + 0.2 * Math.sqrt(Math.abs(lng));
        ret += (20.0 * Math.sin(6.0 * lng * Math.PI) + 20.0 * Math.sin(2.0 * lng * Math.PI)) * 2.0 / 3.0;
        ret += (20.0 * Math.sin(lat * Math.PI) + 40.0 * Math.sin(lat / 3.0 * Math.PI)) * 2.0 / 3.0;
        return ret += (160.0 * Math.sin(lat / 12.0 * Math.PI) + 320.0 * Math.sin(lat * Math.PI / 30.0)) * 2.0 / 3.0;
    }

    public static double transformlng(double lng, double lat) {
        double ret = 300.0 + lng + 2.0 * lat + 0.1 * lng * lng + 0.1 * lng * lat + 0.1 * Math.sqrt(Math.abs(lng));
        ret += (20.0 * Math.sin(6.0 * lng * Math.PI) + 20.0 * Math.sin(2.0 * lng * Math.PI)) * 2.0 / 3.0;
        ret += (20.0 * Math.sin(lng * Math.PI) + 40.0 * Math.sin(lng / 3.0 * Math.PI)) * 2.0 / 3.0;
        return ret += (150.0 * Math.sin(lng / 12.0 * Math.PI) + 300.0 * Math.sin(lng / 30.0 * Math.PI)) * 2.0 / 3.0;
    }

    public static boolean out_of_china(double lng, double lat) {
        if (lng < 72.004 || lng > 137.8347) {
            return true;
        }
        return lat < 0.8293 || lat > 55.8271;
    }

    private GPSConverterUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

