/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.enums;

import cn.allbs.enums.AtmosphericStabilityEnum;
import java.math.BigDecimal;
import java.util.HashMap;

public enum SolarRadiationEnum {
    A("A"),
    B("B"),
    C("C"),
    D("D"),
    E("E"),
    F("F"),
    AB("A~B"),
    BC("B~C"),
    CD("C~D"),
    DE("D~E");

    private final String level;

    public static String solarRadiationLevel(Integer aLevel, double ws) {
        HashMap<Integer, String> solarMap = new HashMap<Integer, String>(9);
        if ((ws = new BigDecimal(ws).setScale(1, 4).doubleValue()) <= 1.9) {
            solarMap.put(AtmosphericStabilityEnum.LEVEL1.getLevel(), A.getLevel());
            solarMap.put(AtmosphericStabilityEnum.LEVEL2.getLevel(), AB.getLevel());
            solarMap.put(AtmosphericStabilityEnum.LEVEL3.getLevel(), B.getLevel());
            solarMap.put(AtmosphericStabilityEnum.LEVEL4.getLevel(), D.getLevel());
            solarMap.put(AtmosphericStabilityEnum.LEVEL5.getLevel(), E.getLevel());
            solarMap.put(AtmosphericStabilityEnum.LEVEL6.getLevel(), F.getLevel());
        } else if (ws > 2.0 && ws <= 2.9) {
            solarMap.put(AtmosphericStabilityEnum.LEVEL1.getLevel(), AB.getLevel());
            solarMap.put(AtmosphericStabilityEnum.LEVEL2.getLevel(), B.getLevel());
            solarMap.put(AtmosphericStabilityEnum.LEVEL3.getLevel(), C.getLevel());
            solarMap.put(AtmosphericStabilityEnum.LEVEL4.getLevel(), D.getLevel());
            solarMap.put(AtmosphericStabilityEnum.LEVEL5.getLevel(), E.getLevel());
            solarMap.put(AtmosphericStabilityEnum.LEVEL6.getLevel(), F.getLevel());
        } else if (ws > 3.0 && ws <= 4.9) {
            solarMap.put(AtmosphericStabilityEnum.LEVEL1.getLevel(), B.getLevel());
            solarMap.put(AtmosphericStabilityEnum.LEVEL2.getLevel(), BC.getLevel());
            solarMap.put(AtmosphericStabilityEnum.LEVEL3.getLevel(), C.getLevel());
            solarMap.put(AtmosphericStabilityEnum.LEVEL4.getLevel(), D.getLevel());
            solarMap.put(AtmosphericStabilityEnum.LEVEL5.getLevel(), D.getLevel());
            solarMap.put(AtmosphericStabilityEnum.LEVEL6.getLevel(), E.getLevel());
        } else if (ws > 5.0 && ws <= 5.9) {
            solarMap.put(AtmosphericStabilityEnum.LEVEL1.getLevel(), C.getLevel());
            solarMap.put(AtmosphericStabilityEnum.LEVEL2.getLevel(), CD.getLevel());
            solarMap.put(AtmosphericStabilityEnum.LEVEL3.getLevel(), D.getLevel());
            solarMap.put(AtmosphericStabilityEnum.LEVEL4.getLevel(), D.getLevel());
            solarMap.put(AtmosphericStabilityEnum.LEVEL5.getLevel(), D.getLevel());
            solarMap.put(AtmosphericStabilityEnum.LEVEL6.getLevel(), D.getLevel());
        } else if (ws >= 6.0) {
            solarMap.put(AtmosphericStabilityEnum.LEVEL1.getLevel(), C.getLevel());
            solarMap.put(AtmosphericStabilityEnum.LEVEL2.getLevel(), D.getLevel());
            solarMap.put(AtmosphericStabilityEnum.LEVEL3.getLevel(), D.getLevel());
            solarMap.put(AtmosphericStabilityEnum.LEVEL4.getLevel(), D.getLevel());
            solarMap.put(AtmosphericStabilityEnum.LEVEL5.getLevel(), D.getLevel());
            solarMap.put(AtmosphericStabilityEnum.LEVEL6.getLevel(), D.getLevel());
        }
        return (String)solarMap.get(aLevel);
    }

    public String getLevel() {
        return this.level;
    }

    private SolarRadiationEnum(String level) {
        this.level = level;
    }
}

