/*
 * Copyright 2002-2019 Drew Noakes and contributors
 *
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 *
 * More information about this project is available at:
 *
 *    https://drewnoakes.com/code/exif/
 *    https://github.com/drewnoakes/metadata-extractor
 */
package cn.allbs.metadata.metadata.file;

import cn.allbs.metadata.lang.annotations.NotNull;
import cn.allbs.metadata.lang.annotations.Nullable;
import cn.allbs.metadata.metadata.TagDescriptor;

import static cn.allbs.metadata.metadata.file.FileSystemDirectory.*;
import static cn.allbs.metadata.metadata.file.FileSystemDirectory.TAG_FILE_SIZE;

/**
 * @author Drew Noakes https://drewnoakes.com
 */
@SuppressWarnings("WeakerAccess")
public class FileSystemDescriptor extends TagDescriptor<FileSystemDirectory>
{
    public FileSystemDescriptor(@NotNull FileSystemDirectory directory)
    {
        super(directory);
    }

    @Override
    @Nullable
    public String getDescription(int tagType)
    {
        switch (tagType) {
            case TAG_FILE_SIZE:
                return getFileSizeDescription();
            default:
                return super.getDescription(tagType);
        }
    }

    @Nullable
    private String getFileSizeDescription()
    {
        Long size = _directory.getLongObject(TAG_FILE_SIZE);

        if (size == null)
            return null;

        return Long.toString(size) + " bytes";
    }
}

