/*
 * Copyright 2002-2019 Drew Noakes and contributors
 *
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 *
 * More information about this project is available at:
 *
 *    https://drewnoakes.com/code/exif/
 *    https://github.com/drewnoakes/metadata-extractor
 */
package cn.allbs.metadata.metadata.mp4.media;

import cn.allbs.metadata.lang.SequentialReader;
import cn.allbs.metadata.lang.annotations.NotNull;
import cn.allbs.metadata.metadata.Metadata;
import cn.allbs.metadata.metadata.mp4.Mp4BoxTypes;
import cn.allbs.metadata.metadata.mp4.Mp4Context;
import cn.allbs.metadata.metadata.mp4.Mp4MediaHandler;
import cn.allbs.metadata.metadata.mp4.boxes.Box;
import cn.allbs.metadata.metadata.mp4.boxes.TimeToSampleBox;
import cn.allbs.metadata.metadata.mp4.boxes.VideoMediaHeaderBox;
import cn.allbs.metadata.metadata.mp4.boxes.VisualSampleEntry;

import java.io.IOException;

public class Mp4VideoHandler extends Mp4MediaHandler<Mp4VideoDirectory>
{
    public Mp4VideoHandler(Metadata metadata, Mp4Context context)
    {
        super(metadata, context);
    }

    @Override
    protected String getMediaInformation()
    {
        return Mp4BoxTypes.BOX_VIDEO_MEDIA_INFO;
    }

    @NotNull
    @Override
    protected Mp4VideoDirectory getDirectory()
    {
        return new Mp4VideoDirectory();
    }

    @Override
    public void processSampleDescription(@NotNull SequentialReader reader, @NotNull Box box) throws IOException
    {
        VisualSampleEntry visualSampleEntry = new VisualSampleEntry(reader, box);
        visualSampleEntry.addMetadata(directory);
    }

    @Override
    public void processMediaInformation(@NotNull SequentialReader reader, @NotNull Box box) throws IOException
    {
        VideoMediaHeaderBox videoMediaHeaderBox = new VideoMediaHeaderBox(reader, box);
        videoMediaHeaderBox.addMetadata(directory);
    }

    @Override
    public void processTimeToSample(@NotNull SequentialReader reader, @NotNull Box box, Mp4Context context) throws IOException
    {
        TimeToSampleBox timeToSampleBox = new TimeToSampleBox(reader, box);
        timeToSampleBox.addMetadata(directory, context);
    }
}
