package cn.allbs.logback.listener;

import cn.allbs.logback.config.LoggingProperties;
import cn.allbs.logback.utils.LoggingUtil;
import lombok.RequiredArgsConstructor;
import org.springframework.boot.web.context.WebServerInitializedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.scheduling.annotation.Async;

/**
 * 项目启动事件通知
 *
 * @author ChenQi
 */
@RequiredArgsConstructor
public class LoggingStartedEventListener {
    private final LoggingProperties properties;

    @Async
    @Order
    @EventListener(WebServerInitializedEvent.class)
    public void afterStart() {
        // 1. 关闭控制台
        LoggingProperties.Console console = properties.getConsole();
        if (console.isCloseAfterStart()) {
            LoggingUtil.detachAppender(LoggingUtil.CONSOLE_APPENDER_NAME);
        }
    }
}
