/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.logback.append;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import cn.allbs.logback.append.ILoggingAppender;
import cn.allbs.logback.config.LoggingProperties;
import cn.allbs.logback.loki.OkHttpSender;
import cn.hutool.core.util.StrUtil;
import com.github.loki4j.logback.AbstractHttpSender;
import com.github.loki4j.logback.AbstractLoki4jEncoder;
import com.github.loki4j.logback.ApacheHttpSender;
import com.github.loki4j.logback.HttpSender;
import com.github.loki4j.logback.JavaHttpSender;
import com.github.loki4j.logback.JsonEncoder;
import com.github.loki4j.logback.Loki4jAppender;
import com.github.loki4j.logback.Loki4jEncoder;
import com.github.loki4j.logback.ProtobufEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;

public class LoggingLokiAppender
implements ILoggingAppender {
    private static final Logger log = LoggerFactory.getLogger(LoggingLokiAppender.class);
    private static final String APPENDER_NAME = "LOKI";
    private final LoggingProperties properties;
    private final String appName;
    private final String profile;

    public LoggingLokiAppender(Environment environment, LoggingProperties properties) {
        this.properties = properties;
        this.appName = environment.getRequiredProperty("spring.application.name");
        this.profile = environment.getRequiredProperty("spring.profiles.active");
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        this.start(context);
    }

    @Override
    public void start(LoggerContext context) {
        log.info("Loki logging start.");
        this.reload(context);
    }

    @Override
    public void reset(LoggerContext context) {
        log.info("Loki logging reset.");
        this.reload(context);
    }

    private void reload(LoggerContext context) {
        LoggingProperties.Loki loki = this.properties.getLoki();
        if (loki.isEnabled()) {
            this.addLokiAppender(context, loki);
        }
    }

    private void addLokiAppender(LoggerContext context, LoggingProperties.Loki properties) {
        Loki4jAppender lokiAppender = new Loki4jAppender();
        lokiAppender.setName(APPENDER_NAME);
        lokiAppender.setContext((Context)context);
        lokiAppender.setBatchMaxItems(properties.getBatchMaxItems());
        lokiAppender.setBatchMaxBytes(properties.getBatchMaxBytes());
        lokiAppender.setBatchTimeoutMs(properties.getBatchTimeoutMs());
        lokiAppender.setSendQueueMaxBytes(properties.getSendQueueMaxBytes());
        lokiAppender.setUseDirectBuffers(properties.isUseDirectBuffers());
        lokiAppender.setDrainOnStop(properties.isDrainOnStop());
        lokiAppender.setMetricsEnabled(properties.isMetricsEnabled());
        lokiAppender.setVerbose(properties.isVerbose());
        Loki4jEncoder loki4jEncoder = this.getFormat(context, properties);
        lokiAppender.setFormat(loki4jEncoder);
        lokiAppender.setHttp(LoggingLokiAppender.getSender(context, loki4jEncoder, properties));
        lokiAppender.start();
        context.getLogger("ROOT").detachAppender(APPENDER_NAME);
        context.getLogger("ROOT").addAppender((Appender)lokiAppender);
    }

    private Loki4jEncoder getFormat(LoggerContext context, LoggingProperties.Loki properties) {
        LoggingProperties.LokiEncoder encoder = properties.getEncoder();
        ProtobufEncoder loki4jEncoder = LoggingProperties.LokiEncoder.ProtoBuf == encoder ? new ProtobufEncoder() : new JsonEncoder();
        AbstractLoki4jEncoder.LabelCfg labelCfg = new AbstractLoki4jEncoder.LabelCfg();
        labelCfg.setPattern(this.formatLabelPatternHandle(context, properties));
        labelCfg.setPairSeparator(properties.getFormatLabelPairSeparator());
        labelCfg.setKeyValueSeparator(properties.getFormatLabelKeyValueSeparator());
        labelCfg.setNopex(properties.isFormatLabelNoPex());
        loki4jEncoder.setLabel(labelCfg);
        AbstractLoki4jEncoder.MessageCfg messageCfg = new AbstractLoki4jEncoder.MessageCfg();
        String formatMessagePattern = properties.getFormatMessagePattern();
        if (StrUtil.isNotBlank((CharSequence)formatMessagePattern)) {
            messageCfg.setPattern(formatMessagePattern);
        }
        loki4jEncoder.setMessage(messageCfg);
        loki4jEncoder.setStaticLabels(properties.isFormatStaticLabels());
        loki4jEncoder.setSortByTime(properties.isFormatSortByTime());
        loki4jEncoder.setContext((Context)context);
        loki4jEncoder.start();
        return loki4jEncoder;
    }

    private static HttpSender getSender(LoggerContext context, Loki4jEncoder loki4jEncoder, LoggingProperties.Loki properties) {
        LoggingProperties.HttpSender httpSenderType = LoggingLokiAppender.getHttpSender(properties);
        Object httpSender = LoggingProperties.HttpSender.OKHttp == httpSenderType ? new OkHttpSender() : (LoggingProperties.HttpSender.ApacheHttp == httpSenderType ? new ApacheHttpSender() : new JavaHttpSender());
        httpSender.setUrl(properties.getHttpUrl());
        httpSender.setConnectionTimeoutMs(properties.getHttpConnectionTimeoutMs());
        httpSender.setRequestTimeoutMs(properties.getHttpRequestTimeoutMs());
        String authUsername = properties.getHttpAuthUsername();
        String authPassword = properties.getHttpAuthPassword();
        if (StrUtil.isNotBlank((CharSequence)authUsername) && StrUtil.isNotBlank((CharSequence)authPassword)) {
            AbstractHttpSender.BasicAuth basicAuth = new AbstractHttpSender.BasicAuth();
            basicAuth.setUsername(authUsername);
            basicAuth.setPassword(authPassword);
            httpSender.setAuth(basicAuth);
        }
        httpSender.setTenantId(properties.getHttpTenantId());
        httpSender.setContentType(loki4jEncoder.getContentType());
        httpSender.setContext((Context)context);
        httpSender.start();
        return httpSender;
    }

    private String formatLabelPatternHandle(LoggerContext context, LoggingProperties.Loki properties) {
        String labelPattern = properties.getFormatLabelPattern();
        String labelPatternExtend = properties.getFormatLabelPatternExtend();
        if (StrUtil.isNotBlank((CharSequence)labelPatternExtend)) {
            labelPattern = labelPattern + ',' + labelPatternExtend;
        }
        return labelPattern.replace("${appName}", this.appName).replace("${profile}", this.profile).replace("${HOSTNAME}", context.getProperty("HOSTNAME"));
    }

    private static LoggingProperties.HttpSender getHttpSender(LoggingProperties.Loki properties) {
        LoggingProperties.HttpSender httpSenderProp = properties.getHttpSender();
        if (httpSenderProp != null && httpSenderProp.isAvailable()) {
            log.debug("allbs logging use {} HttpSender", (Object)httpSenderProp);
            return httpSenderProp;
        }
        if (httpSenderProp == null) {
            LoggingProperties.HttpSender[] httpSenders;
            for (LoggingProperties.HttpSender httpSender : httpSenders = LoggingProperties.HttpSender.values()) {
                if (!httpSender.isAvailable()) continue;
                log.debug("allbs logging use {} HttpSender", (Object)httpSender);
                return httpSender;
            }
            throw new IllegalArgumentException("Not java11 and no okHttp or apache http dependency.");
        }
        throw new NoClassDefFoundError(httpSenderProp.getSenderClass());
    }
}

