package cn.allbs.logback.config;

import cn.allbs.logback.utils.LoggingUtil;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;

import java.util.HashMap;
import java.util.Map;

/**
 * 日志初始化
 *
 * @author ChenQi
 */
public class LoggingInitializer implements EnvironmentPostProcessor, Ordered {
    public static final String LOGGING_FILE_PATH_KEY = "logging.file.path";
    public static final String LOGGING_FILE_NAME_KEY = "logging.file.name";
    public static final String ALLBS_LOGGING_PROPERTY_SOURCE_NAME = "allbsLoggingPropertySource";

    @Override
    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        // 读取系统配置的日志目录，默认为项目下 logs
        String logBase = environment.getProperty(LOGGING_FILE_PATH_KEY, LoggingUtil.DEFAULT_LOG_DIR);
        // 用于 spring boot admin 中展示日志
        if (!environment.containsProperty(LOGGING_FILE_NAME_KEY)) {
            Map<String, Object> map = new HashMap<>(2);
            map.put(LOGGING_FILE_NAME_KEY, logBase + "/${spring.application.name}/" + LoggingUtil.LOG_FILE_ALL);
            MapPropertySource propertySource = new MapPropertySource(ALLBS_LOGGING_PROPERTY_SOURCE_NAME, map);
            environment.getPropertySources().addLast(propertySource);
        }
    }

    @Override
    public int getOrder() {
        return Ordered.LOWEST_PRECEDENCE;
    }

}
