package cn.allbs.logback.append;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import cn.allbs.common.utils.JsonUtil;
import cn.allbs.logback.config.LoggingProperties;
import cn.allbs.logback.utils.LogStashUtil;
import lombok.extern.slf4j.Slf4j;
import net.logstash.logback.appender.LogstashTcpSocketAppender;
import net.logstash.logback.encoder.LogstashEncoder;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;

import java.util.HashMap;
import java.util.Map;

/**
 * @author ChenQi
 */
@Slf4j
public class LoggingLogStashAppender implements ILoggingAppender {
    private static final String ASYNC_LOG_STASH_APPENDER_NAME = "ASYNC_LOG_STASH";
    private final LoggingProperties properties;
    private final String customFieldsJson;

    public LoggingLogStashAppender(Environment environment,
                                   LoggingProperties properties) {
        this.properties = properties;
        // 1. 服务名和环境
        String appName = environment.getRequiredProperty("spring.application.name");
        String profile = environment.getRequiredProperty("spring.profiles.active");
        // 2. json 自定义字段
        Map<String, Object> customFields = new HashMap<>(4);
        customFields.put("appName", appName);
        customFields.put("profile", profile);
        this.customFieldsJson = JsonUtil.toJson(customFields);
        LoggerContext context = (LoggerContext) LoggerFactory.getILoggerFactory();
        this.start(context);
    }

    @Override
    public void start(LoggerContext context) {
        log.info("LogStash logging start.");
        reload(context);
    }

    @Override
    public void reset(LoggerContext context) {
        log.info("LogStash logging reset.");
        reload(context);
    }

    private void reload(LoggerContext context) {
        LoggingProperties.Logstash logStash = properties.getLogstash();
        if (logStash.isEnabled()) {
            addLogStashTcpSocketAppender(context, customFieldsJson, logStash);
        }
    }

    /**
     * addLogstashTcpSocketAppender.
     *
     * @param context            a {@link LoggerContext} object.
     * @param customFields       a {@link String} object.
     * @param logStashProperties a {@link cn.allbs.logback.config.LoggingProperties.Logstash} object.
     */
    private static void addLogStashTcpSocketAppender(LoggerContext context,
                                                     String customFields,
                                                     LoggingProperties.Logstash logStashProperties) {
        // More documentation is available at: https://github.com/logstash/logstash-logback-encoder
        final LogstashTcpSocketAppender logStashAppender = new LogstashTcpSocketAppender();
        logStashAppender.addDestination(logStashProperties.getDestinations());
        logStashAppender.setContext(context);
        logStashAppender.setEncoder(logstashEncoder(customFields));
        logStashAppender.setName(ASYNC_LOG_STASH_APPENDER_NAME);
        logStashAppender.setQueueSize(logStashProperties.getQueueSize());
        logStashAppender.start();
        // 先删除，再添加
        context.getLogger(Logger.ROOT_LOGGER_NAME).detachAppender(ASYNC_LOG_STASH_APPENDER_NAME);
        context.getLogger(Logger.ROOT_LOGGER_NAME).addAppender(logStashAppender);
    }

    private static LogstashEncoder logstashEncoder(String customFields) {
        final LogstashEncoder logstashEncoder = new LogstashEncoder();
        logstashEncoder.setThrowableConverter(LogStashUtil.throwableConverter());
        logstashEncoder.setCustomFields(customFields);
        return logstashEncoder;
    }

}
