package cn.allbs.logback.listener;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.LoggerContextListener;
import ch.qos.logback.core.spi.ContextAwareBase;
import cn.allbs.logback.append.ILoggingAppender;
import lombok.RequiredArgsConstructor;

import java.util.List;

/**
 * Logback configuration is achieved by configuration file and API.
 * When configuration file change is detected, the configuration is reset.
 * This listener ensures that the programmatic configuration is also re-applied after reset.
 *
 * @author ChenQi
 */
@RequiredArgsConstructor
public class LogbackLoggerContextListener extends ContextAwareBase implements LoggerContextListener {
    private final List<ILoggingAppender> appenderList;

    @Override
    public boolean isResetResistant() {
        return true;
    }

    @Override
    public void onStart(LoggerContext context) {
        for (ILoggingAppender appender : appenderList) {
            appender.start(context);
        }
    }

    @Override
    public void onReset(LoggerContext context) {
        for (ILoggingAppender appender : appenderList) {
            appender.reset(context);
        }
    }

    @Override
    public void onStop(LoggerContext context) {
        // Nothing to do.
    }

    @Override
    public void onLevelChange(Logger logger, Level level) {
        // Nothing to do.
    }
}
