/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.idempotent.expression;

import cn.allbs.idempotent.annotation.Idempotent;
import cn.allbs.idempotent.expression.KeyResolver;
import java.lang.reflect.Method;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

public class ExpressionResolver
implements KeyResolver {
    private static final SpelExpressionParser PARSER = new SpelExpressionParser();
    private static final LocalVariableTableParameterNameDiscoverer DISCOVERER = new LocalVariableTableParameterNameDiscoverer();

    @Override
    public String resolver(Idempotent idempotent, JoinPoint point) {
        Object[] arguments = point.getArgs();
        String[] params = DISCOVERER.getParameterNames(this.getMethod(point));
        StandardEvaluationContext context = new StandardEvaluationContext();
        if (params != null && params.length > 0) {
            for (int len = 0; len < params.length; ++len) {
                context.setVariable(params[len], arguments[len]);
            }
        }
        Expression expression = PARSER.parseExpression(idempotent.key());
        return (String)expression.getValue((EvaluationContext)context, String.class);
    }

    private Method getMethod(JoinPoint joinPoint) {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Method method = signature.getMethod();
        if (method.getDeclaringClass().isInterface()) {
            try {
                method = joinPoint.getTarget().getClass().getDeclaredMethod(joinPoint.getSignature().getName(), method.getParameterTypes());
            }
            catch (NoSuchMethodException | SecurityException e) {
                throw new RuntimeException(e);
            }
        }
        return method;
    }
}

