/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.hj212.format;

import cn.allbs.hj212.config.T212Configurator;
import cn.allbs.hj212.core.Configured;
import cn.allbs.hj212.deser.T212Deserializer;
import cn.allbs.hj212.format.T212Generator;
import cn.allbs.hj212.format.T212Parser;
import cn.allbs.hj212.ser.T212Serializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.stream.Stream;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class T212Factory {
    private T212Configurator configurator = new T212Configurator();
    protected final HashMap<Type, T212Deserializer<Object>> _rootDeserializers = new HashMap();
    protected final HashMap<Type, T212Serializer<Object>> _rootSerializers = new HashMap();

    public T212Factory() {
    }

    public T212Factory(T212Configurator configurator) {
        this.configurator = configurator;
    }

    public T212Factory copy() {
        T212Factory factory = new T212Factory();
        factory.setConfigurator(this.configurator);
        factory._rootDeserializers.putAll(this._rootDeserializers);
        factory._rootSerializers.putAll(this._rootSerializers);
        return factory;
    }

    public T212Configurator getConfigurator() {
        return this.configurator;
    }

    public void setConfigurator(T212Configurator configurator) {
        this.configurator = configurator;
    }

    public T212Parser parser(InputStream is) {
        InputStreamReader dis = new InputStreamReader(is);
        T212Parser parser = new T212Parser(dis);
        parser.configured(this.configurator);
        return parser;
    }

    public T212Parser parser(byte[] bytes) {
        return this.parser(new ByteArrayInputStream(bytes));
    }

    public T212Parser parser(Reader reader) {
        T212Parser parser = new T212Parser(reader);
        parser.configured(this.configurator);
        return parser;
    }

    public T212Parser parser(char[] chars) {
        return this.parser(new CharArrayReader(chars));
    }

    public T212Parser parser(String msg) {
        return this.parser(new StringReader(msg));
    }

    public <T> T212Deserializer<T> deserializerFor(Class<T> tClass) {
        T212Deserializer<Object> deserializer = this._rootDeserializers.get(tClass);
        if (deserializer instanceof Configured) {
            Configured configured = (Configured)((Object)deserializer);
            configured.configured(this.configurator);
        }
        return deserializer;
    }

    public <T> T212Deserializer<T> deserializerFor(Type type, Class<T> tClass) {
        T212Deserializer<Object> deserializer = this._rootDeserializers.get(type);
        if (deserializer instanceof Configured) {
            Configured configured = (Configured)((Object)deserializer);
            configured.configured(this.configurator);
        }
        return deserializer;
    }

    public void deserializerRegister(Class<? extends T212Deserializer> deserializerClass) throws InstantiationException, IllegalAccessException {
        Type type = (Type)((Object)Stream.of(deserializerClass.getGenericInterfaces()).filter(t -> t instanceof ParameterizedType).map(t -> (ParameterizedType)t).filter(pt -> pt.getRawType().equals(T212Deserializer.class)).map(pt -> pt.getActualTypeArguments()[0]).findFirst().orElse((Type)((Object)Object.class)));
        this.deserializerRegister(type, deserializerClass);
    }

    public void deserializerRegister(Type type, Class<? extends T212Deserializer> deserializerClass) throws IllegalAccessException, InstantiationException {
        this._rootDeserializers.put(type, deserializerClass.newInstance());
    }

    public T212Generator generator(OutputStream os) {
        OutputStreamWriter osw = new OutputStreamWriter(os);
        T212Generator generator = new T212Generator(osw);
        generator.configured(this.configurator);
        return generator;
    }

    public T212Generator generator(Writer writer) {
        T212Generator generator = new T212Generator(writer);
        generator.configured(this.configurator);
        return generator;
    }

    public <T> T212Serializer<T> serializerFor(Class<T> value) {
        T212Serializer<Object> serializer = this._rootSerializers.get(value);
        if (serializer instanceof Configured) {
            Configured configured = (Configured)((Object)serializer);
            configured.configured(this.configurator);
        }
        return serializer;
    }

    public void serializerRegister(Class<? extends T212Serializer> serializerClass) throws InstantiationException, IllegalAccessException {
        Type type = (Type)((Object)Stream.of(serializerClass.getGenericInterfaces()).filter(t -> t instanceof ParameterizedType).map(t -> (ParameterizedType)t).filter(pt -> pt.getRawType().equals(T212Serializer.class)).map(pt -> pt.getActualTypeArguments()[0]).findFirst().orElse((Type)((Object)Object.class)));
        this.serializerRegister(type, serializerClass);
    }

    public void serializerRegister(Type type, Class<? extends T212Serializer> serializerClass) throws IllegalAccessException, InstantiationException {
        this._rootSerializers.put(type, serializerClass.newInstance());
    }

    public Validator validator() {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        return factory.getValidator();
    }

    public ObjectMapper objectMapper() {
        return null;
    }
}

