/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.hj212.enums;

import cn.allbs.hj212.translator.ValueLabel;
import cn.allbs.hj212.translator.ValueMatch;
import cn.allbs.hj212.translator.ValuePattern;
import java.util.function.Predicate;
import java.util.regex.Pattern;

public enum SystemType implements ValueLabel,
ValueMatch,
ValuePattern
{
    _10_29("\u73af\u5883\u8d28\u91cf\u7c7b\u522b", "[12]\\d"),
    _30_49("\u73af\u5883\u6c61\u67d3\u6e90\u7c7b\u522b", "[34]\\d"),
    _50_69("\u5de5\u51b5\u7c7b\u522b", "[56]\\d"),
    _91_99("\u7cfb\u7edf\u4ea4\u4e92\u7c7b\u522b", "[9][1-9]"),
    _A0_Z9("\u4e8e\u672a\u77e5\u7cfb\u7edf\u7f16\u7801\u6269\u5c55", "[A-Z][A-Z0-9]|[A-Z0-9][A-Z]"),
    _UNKNOW("\u672a\u77e5", "[0-9A-Z]{2}", 10000);

    private final String code = this.name().substring(1);
    private final String meaning;
    private final String pattern;
    private final Predicate<String> predicate;
    private final int order;

    private SystemType(String meaning, String pattern) {
        this.meaning = meaning;
        this.pattern = pattern;
        this.predicate = Pattern.compile(this.pattern).asPredicate();
        this.order = this.ordinal();
    }

    private SystemType(String meaning, String pattern, int order) {
        this.meaning = meaning;
        this.pattern = pattern;
        this.predicate = Pattern.compile(this.pattern).asPredicate();
        this.order = order;
    }

    @Override
    public String value() {
        return this.code;
    }

    @Override
    public String label() {
        return this.meaning;
    }

    @Override
    public String pattern() {
        return this.pattern;
    }

    @Override
    public boolean match(String code) {
        return this.predicate.test(code);
    }

    @Override
    public int order() {
        return this.order;
    }

    public String getCode() {
        return this.code;
    }

    public String getMeaning() {
        return this.meaning;
    }

    public String getPattern() {
        return this.pattern;
    }

    public Predicate<String> getPredicate() {
        return this.predicate;
    }

    public int getOrder() {
        return this.order;
    }
}

