/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.hj212.enums;

import cn.allbs.hj212.translator.ValueLabel;
import cn.allbs.hj212.translator.ValueMatch;
import cn.allbs.hj212.translator.ValuePattern;
import java.util.function.Predicate;
import java.util.regex.Pattern;

public enum CommandType implements ValueLabel,
ValueMatch,
ValuePattern
{
    REQUEST("\u8bf7\u6c42\u547d\u4ee4", "[1]\\d{3}"),
    UPLOAD("\u4e0a\u4f20\u547d\u4ee4", "[2]\\d{3}"),
    NOTICE("\u901a\u77e5\u547d\u4ee4", "[3]\\d{3}"),
    SHELL("\u4ea4\u4e92\u547d\u4ee4", "[9]\\d{3}"),
    UNKNOW("\u672a\u77e5", "\\d{4}", 10000);

    private final String value;
    private final String label;
    private final String pattern;
    private final Predicate<String> predicate;
    private final int order;

    private CommandType(String label, String pattern) {
        this.value = this.name();
        this.label = label;
        this.pattern = pattern;
        this.predicate = Pattern.compile(this.pattern).asPredicate();
        this.order = this.ordinal();
    }

    private CommandType(String label, String pattern, int order) {
        this.value = this.name();
        this.label = label;
        this.pattern = pattern;
        this.predicate = Pattern.compile(this.pattern).asPredicate();
        this.order = order;
    }

    @Override
    public String value() {
        return this.value;
    }

    @Override
    public String label() {
        return this.label;
    }

    @Override
    public String pattern() {
        return this.pattern;
    }

    @Override
    public int order() {
        return this.order;
    }

    @Override
    public boolean match(String value) {
        return this.predicate.test(value);
    }

    public String getValue() {
        return this.value;
    }

    public String getLabel() {
        return this.label;
    }

    public String getPattern() {
        return this.pattern;
    }

    public Predicate<String> getPredicate() {
        return this.predicate;
    }

    public int getOrder() {
        return this.order;
    }

    private CommandType(String value, String label, String pattern, Predicate<String> predicate, int order) {
        this.value = value;
        this.label = label;
        this.pattern = pattern;
        this.predicate = predicate;
        this.order = order;
    }
}

