/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.hj212.core;

import cn.allbs.hj212.core.MultipleCharMatch;
import cn.allbs.hj212.core.NoneReadMatch;
import cn.allbs.hj212.core.ReaderMatch;
import cn.allbs.hj212.core.SingleCharMatch;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.nio.CharBuffer;
import java.util.Optional;
import java.util.function.Consumer;

public class ReaderStream<ParentMatch extends ReaderMatch> {
    private PushbackReader reader;
    private int bufSize = 1024;
    private ReaderMatch childMatch;
    private ParentMatch parentMatch;

    public static ReaderStream<NoneReadMatch> of() {
        return new ReaderStream<NoneReadMatch>(null);
    }

    public static ReaderStream<NoneReadMatch> of(PushbackReader reader) {
        return new ReaderStream<NoneReadMatch>(reader);
    }

    public static ReaderStream<NoneReadMatch> of(Reader reader) {
        return new ReaderStream<NoneReadMatch>(reader, 0);
    }

    public static ReaderStream<NoneReadMatch> of(Reader reader, int pushBackCount) {
        return new ReaderStream<NoneReadMatch>(reader, pushBackCount);
    }

    public ReaderStream(PushbackReader reader) {
        this.use(reader);
    }

    public ReaderStream(Reader reader, int bufSize) {
        this.use(reader, bufSize);
    }

    public ReaderStream(PushbackReader reader, int bufSize, ParentMatch parentMatch) {
        this.use(reader, bufSize, parentMatch);
    }

    public ReaderStream(Reader reader, int bufSize, ParentMatch parentMatch) {
        this.use(reader, bufSize, parentMatch);
    }

    public ReaderStream<ParentMatch> use(PushbackReader reader) {
        Field field = null;
        try {
            field = reader.getClass().getDeclaredField("buf");
            field.setAccessible(true);
            char[] chars = (char[])field.get(reader);
            if (chars.length < 1) {
                this.reader = new PushbackReader(reader, this.bufSize);
                return this;
            }
            this.bufSize = chars.length;
            this.reader = reader;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this;
    }

    public ReaderStream<ParentMatch> use(Reader reader) {
        return this.use(reader, 0);
    }

    public ReaderStream<ParentMatch> use(Reader reader, int bufSize) {
        if (bufSize > 0) {
            this.bufSize = bufSize;
        }
        this.reader = new PushbackReader(reader, this.bufSize);
        return this;
    }

    public ReaderStream<ParentMatch> use(PushbackReader reader, int bufSize, ParentMatch parentMatch) {
        if (bufSize < 1) {
            this.reader = new PushbackReader(reader, this.bufSize);
            this.parentMatch = parentMatch;
            return this;
        }
        this.bufSize = bufSize;
        this.reader = reader;
        this.parentMatch = parentMatch;
        return this;
    }

    public ReaderStream<ParentMatch> use(Reader reader, int bufSize, ParentMatch parentMatch) {
        if (bufSize > 0) {
            this.bufSize = bufSize;
        }
        this.reader = new PushbackReader(reader, this.bufSize);
        this.parentMatch = parentMatch;
        return this;
    }

    protected PushbackReader reader() {
        return this.reader;
    }

    protected int bufSize() {
        return this.bufSize;
    }

    public SingleCharMatch<ReaderStream<ParentMatch>> next() {
        SingleCharMatch<ReaderStream<ParentMatch>> charMatch;
        this.childMatch = charMatch = new SingleCharMatch<ReaderStream<ParentMatch>>(this);
        return charMatch;
    }

    public MultipleCharMatch<ReaderStream<ParentMatch>> next(int count) {
        MultipleCharMatch<ReaderStream<ParentMatch>> charMatch;
        this.childMatch = charMatch = new MultipleCharMatch<ReaderStream<ParentMatch>>(this, count);
        return charMatch;
    }

    public ParentMatch back() {
        return this.parentMatch;
    }

    public Optional<Object> match() throws IOException {
        return this.childMatch.match();
    }

    public int read() throws IOException {
        int count = 0;
        while (!this.match().isPresent()) {
            this.reader.skip(1L);
            ++count;
        }
        return count;
    }

    public int read(CharBuffer charBuffer) throws IOException {
        int i;
        int count = 0;
        int len = charBuffer.remaining();
        while (len > 0 && !this.match().isPresent() && (i = this.reader.read()) != -1) {
            charBuffer.append((char)i);
            --len;
            ++count;
        }
        return count;
    }

    public ReaderStream read(int maxCount, Consumer<CharBuffer> consumer) throws IOException {
        CharBuffer charBuffer = CharBuffer.allocate(maxCount);
        this.read(charBuffer);
        consumer.accept(charBuffer);
        return this;
    }

    public String toString() {
        return (this.parentMatch != null ? this.parentMatch.toString() : "") + "/" + this.getClass().getSimpleName() + "(" + this.bufSize + ")";
    }
}

