/*
 * Decompiled with CFR 0.152.
 */
package cn.allbs.hj212.config;

import cn.allbs.hj212.config.SegmentToken;
import cn.allbs.hj212.core.Configurator;
import cn.allbs.hj212.core.Configured;
import cn.allbs.hj212.core.ReaderStream;
import cn.allbs.hj212.feature.SegmentParserFeature;
import java.io.Closeable;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.nio.CharBuffer;
import java.util.Optional;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicReference;

public class SegmentParser
implements Closeable,
Configured<SegmentParser> {
    protected PushbackReader reader;
    private int parserFeature;
    private SegmentToken currentToken;
    private Stack<String> path;

    public SegmentParser(Reader reader) {
        this.reader = new PushbackReader(reader, 3);
        this.path = new Stack();
    }

    public String readKey() throws IOException {
        return this.readPathKey(false);
    }

    public String readPathKey() throws IOException {
        return this.readPathKey(true);
    }

    private String readPathKey(boolean supportSubKey) throws IOException {
        switch (this.currentToken) {
            case END_KEY: {
                throw new IOException("Cant read key after END_KEY token!");
            }
            case END_OBJECT_VALUE: {
                ReaderStream.of(this.reader).next().when(xva$0 -> SegmentToken.END_SUB_ENTRY.isSame((char)xva$0)).then(() -> {
                    this.currentToken = SegmentToken.END_SUB_ENTRY;
                }).when(xva$0 -> SegmentToken.END_ENTRY.isSame((char)xva$0)).then(() -> {
                    this.currentToken = SegmentToken.END_ENTRY;
                }).done().match();
            }
        }
        CharBuffer buffer = CharBuffer.allocate(20);
        int len = ReaderStream.of(this.reader).next().when(xva$0 -> SegmentToken.NOT_AVAILABLE.isSame((char)xva$0)).then(() -> {
            this.currentToken = SegmentToken.NOT_AVAILABLE;
        }).when(c -> supportSubKey && SegmentToken.END_PART_KEY.isSame(c.charValue())).then(() -> {
            this.currentToken = SegmentToken.END_PART_KEY;
        }).when(xva$0 -> SegmentToken.END_KEY.isSame((char)xva$0)).then().next(2).when(SegmentToken.START_OBJECT_VALUE::isSame).then(() -> {
            this.currentToken = SegmentToken.START_OBJECT_VALUE;
        }).done().back().then(() -> {
            this.currentToken = SegmentToken.END_KEY;
        }).when(xva$0 -> SegmentToken.END_SUB_ENTRY.isSame((char)xva$0)).then(() -> {
            if (!SegmentParserFeature.ALLOW_ISOLATED_KEY.enabledIn(this.parserFeature)) {
                throw new IOException("Missing '=' between key and (null)value");
            }
            this.currentToken = SegmentToken.END_SUB_ENTRY;
        }).when(xva$0 -> SegmentToken.END_ENTRY.isSame((char)xva$0)).then(() -> {
            if (!SegmentParserFeature.ALLOW_ISOLATED_KEY.enabledIn(this.parserFeature)) {
                throw new IOException("Missing '=' between key and (null)value");
            }
            this.currentToken = SegmentToken.END_ENTRY;
        }).when(SegmentToken.START_OBJECT_VALUE::isStart).then().next().when(SegmentToken.START_OBJECT_VALUE::isStart).then(() -> {
            if (this.path.empty()) {
                if (!SegmentParserFeature.ALLOW_KEY_NOT_CLOSED.enabledIn(this.parserFeature)) {
                    throw new IOException("Missing '=' between key and (object)value");
                }
                this.currentToken = SegmentToken.START_OBJECT_VALUE;
            } else {
                this.currentToken = SegmentToken.END_OBJECT_VALUE;
            }
        }).done().back().then(() -> {
            if (!SegmentParserFeature.IGNORE_INVAILD_SYMBOL.enabledIn(this.parserFeature)) {
                throw new IOException("Invaild symbol '&' in key");
            }
        }).done().read(buffer);
        if (this.currentToken == SegmentToken.END_OBJECT_VALUE) {
            this.path.pop();
        }
        if (len == 0) {
            return null;
        }
        buffer.rewind();
        String result = buffer.toString().substring(0, len);
        if (this.currentToken == SegmentToken.START_OBJECT_VALUE) {
            this.path.push(result);
        }
        return result;
    }

    public String readValue() throws IOException {
        return this.readValue(false);
    }

    public String readObjectValue() throws IOException {
        return this.readValue(true);
    }

    private String readValue(boolean onlyObject) throws IOException {
        boolean basic = !onlyObject;
        switch (this.currentToken) {
            case END_OBJECT_VALUE: 
            case END_ENTRY: 
            case END_SUB_ENTRY: 
            case END_PART_KEY: {
                throw new IOException("Cant read value after " + this.currentToken.name() + " token!");
            }
            case START_OBJECT_VALUE: {
                if (onlyObject) {
                    basic = false;
                    break;
                }
                throw new IOException("Cant read base value after " + this.currentToken.name() + " token!");
            }
        }
        AtomicReference<Integer> deep = new AtomicReference<Integer>(0);
        CharBuffer buffer = CharBuffer.allocate(basic ? 50 : 1024);
        boolean finalBasic = basic;
        int len = ReaderStream.of(this.reader).next().when(xva$0 -> SegmentToken.NOT_AVAILABLE.isSame((char)xva$0)).then(() -> {
            this.currentToken = SegmentToken.NULL_VALUE;
        }).when(c -> finalBasic && SegmentToken.END_SUB_ENTRY.isSame(c.charValue())).then(() -> {
            this.currentToken = SegmentToken.END_SUB_ENTRY;
        }).when(c -> finalBasic && SegmentToken.END_ENTRY.isSame(c.charValue())).then(() -> {
            this.currentToken = SegmentToken.END_ENTRY;
        }).when(xva$0 -> SegmentToken.END_KEY.isSame((char)xva$0)).then().next(2).when(SegmentToken.START_OBJECT_VALUE::isSame).then(() -> deep.getAndSet((Integer)deep.get() + 4)).back().back().when(c -> SegmentToken.START_OBJECT_VALUE.isStart(c.charValue())).then().next().when(SegmentToken.START_OBJECT_VALUE::isStart).then(() -> {
            if ((Integer)deep.get() == 0) {
                this.currentToken = SegmentToken.END_OBJECT_VALUE;
                return Optional.of(true);
            }
            return Optional.empty();
        }).done().back().then(() -> {
            if ((Integer)deep.get() != 0) {
                deep.getAndSet((Integer)deep.get() - 1);
                return Optional.empty();
            }
            if (!SegmentParserFeature.IGNORE_INVAILD_SYMBOL.enabledIn(this.parserFeature)) {
                // empty if block
            }
            return Optional.empty();
        }).done().read(buffer);
        if (this.currentToken == SegmentToken.END_OBJECT_VALUE) {
            this.path.pop();
        }
        if (len == 0) {
            return null;
        }
        buffer.rewind();
        String result = buffer.toString().substring(0, len);
        return result;
    }

    public SegmentToken currentToken() {
        return this.currentToken;
    }

    public void initToken() {
        this.currentToken = SegmentToken.START_OBJECT_VALUE;
    }

    public void setParserFeature(int parserFeature) {
        this.parserFeature = parserFeature;
    }

    @Override
    public void close() {
        try {
            this.reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void configured(Configurator<SegmentParser> by) {
        by.config(this);
    }
}

